/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.aspect.vlsi.client.thread;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class HttpConfigurationCompilerBaseAspect {
    private static final Log _logger = LogFactory.getLog(HttpConfigurationCompilerBaseAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ HttpConfigurationCompilerBaseAspect ajc$perSingletonInstance;

    static {
        try {
            HttpConfigurationCompilerBaseAspect.ajc$perSingletonInstance = new HttpConfigurationCompilerBaseAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerImpl.ConnectionMonitorThread.new(..))")
    /* synthetic */ void newConnectionMonitorThread() {
    }

    @Pointcut(value="execution(com.vmware.vim.vmomi.client.http.impl.HttpAsyncConfigurationCompilerImpl.ConnectionMonitorThread.new(..))")
    /* synthetic */ void newAsyncConnectionMonitorThread() {
    }

    @Pointcut(value="execution(void com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase.ConnectionMonitorThreadBase.run(..))")
    /* synthetic */ void runConnectionMonitorThread() {
    }

    @AfterReturning(value="newConnectionMonitorThread() || newAsyncConnectionMonitorThread()")
    public void logStackTrace(JoinPoint joinPoint) {
        StackTraceElement[] threadStackTrace = Thread.currentThread().getStackTrace();
        if (threadStackTrace == null || threadStackTrace.length == 0) {
            return;
        }
        Object newObject = joinPoint.getThis();
        String threadName = newObject instanceof Thread ? ((Thread)newObject).getName() : "VLSI-client-connection-monitor-UKN";
        StringBuilder threadDump = new StringBuilder(String.valueOf(threadName) + " thread creation detected from: ");
        int i = 2;
        while (i < threadStackTrace.length) {
            StackTraceElement elem = threadStackTrace[i];
            threadDump.append(elem.toString());
            threadDump.append("\n");
            ++i;
        }
        _logger.info((Object)threadDump);
    }

    @Around(value="runConnectionMonitorThread()")
    public Object logConnectionMonitorThreadExecution(ProceedingJoinPoint joinPoint) {
        String threadName = Thread.currentThread().getName();
        try {
            Object result;
            HttpConfigurationCompilerBaseAspect._logger.info((Object)(String.valueOf(threadName) + " thread started..."));
            Object object = result = joinPoint.proceed();
            return object;
        }
        finally {
            HttpConfigurationCompilerBaseAspect._logger.info((Object)(String.valueOf(threadName) + " thread ended."));
        }
    }

    public static HttpConfigurationCompilerBaseAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.vmware.vise.aspect.vlsi.client.thread.HttpConfigurationCompilerBaseAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

