/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogAppender
extends SyslogAppenderBase<ILoggingEvent> {
    public static final String DEFAULT_APP_NAME = "";
    String appName = "";
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";
    public static final String DEFAULT_STACKTRACE_PATTERN = "\t";
    PatternLayout stackTraceLayout = new PatternLayout();
    String stackTracePattern = "\t";
    boolean throwableExcluded = false;

    public void start() {
        super.start();
        this.setupStackTraceLayout();
    }

    String getPrefixPattern() {
        return "%syslogStart{" + this.getFacility() + "}%nopex{}";
    }

    public int getSeverityForEvent(Object eventObject) {
        ILoggingEvent event = (ILoggingEvent)eventObject;
        return LevelToSyslogSeverity.convert(event);
    }

    protected void postProcess(Object eventObject, OutputStream sw) {
        if (this.throwableExcluded) {
            return;
        }
        ILoggingEvent event = (ILoggingEvent)eventObject;
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp == null) {
            return;
        }
        String stackTracePrefix = this.stackTraceLayout.doLayout(event);
        while (tp != null) {
            StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
            try {
                StackTraceElementProxy[] stackTraceElementProxyArray = stepArray;
                int n = stepArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElementProxy step = stackTraceElementProxyArray[n2];
                    StringBuilder sb = new StringBuilder();
                    sb.append(stackTracePrefix).append(step);
                    sw.write(sb.toString().getBytes());
                    sw.flush();
                    ++n2;
                }
            }
            catch (IOException e) {
                break;
            }
            tp = tp.getCause();
        }
    }

    public Layout<ILoggingEvent> buildHeaderLayout() {
        PatternLayout headerLayout = new PatternLayout();
        headerLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        headerLayout.setPattern(String.valueOf(this.getPrefixPattern()) + this.getAppName() + " ");
        headerLayout.setContext(this.getContext());
        headerLayout.start();
        return headerLayout;
    }

    public Layout<ILoggingEvent> buildMessageLayout() {
        PatternLayout messageLayout = new PatternLayout();
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        messageLayout.setPattern(this.suffixPattern);
        messageLayout.setContext(this.getContext());
        messageLayout.start();
        return messageLayout;
    }

    private void setupStackTraceLayout() {
        this.stackTraceLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        this.stackTraceLayout.setPattern(String.valueOf(this.getPrefixPattern()) + this.getAppName() + " " + this.stackTracePattern);
        this.stackTraceLayout.setContext(this.getContext());
        this.stackTraceLayout.start();
    }

    public void setThrowableExcluded(boolean throwableExcluded) {
        this.throwableExcluded = throwableExcluded;
    }

    public String getStackTracePattern() {
        return this.stackTracePattern;
    }

    public void setStackTracePattern(String stackTracePattern) {
        this.stackTracePattern = stackTracePattern;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

