/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.SimpleTimeBasedCacheImpl;
import com.vmware.cis.license.common.misc.Pair;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetIdentifier;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.fault.AlreadyExistsFault;
import com.vmware.vim.binding.cis.license.fault.AssignmentFault;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.cis.license.management.AssetManagementService;
import com.vmware.vim.binding.cis.license.management.AssetRegisterSpec;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByIdentifiers;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByIds;
import com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec;
import com.vmware.vim.binding.cis.license.management.AssetUpdateSpec;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdentifiersImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdsImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class CacheAssetManagementServiceImpl
implements AssetManagementService {
    private final AssetManagementService _assetManagementService;
    private final Cache<URI, Asset> _assetUriToAssetCache;
    private final Cache<Pair<String, String>, URI> _assetIdToAssetUriCache;
    private final Cache<URI, LicenseUtilization> _assetUriToLicenseUtilizationCache;

    public CacheAssetManagementServiceImpl(AssetManagementService assetManagementService, long invalidationIntervalMs, int cacheCapacity) {
        this._assetManagementService = assetManagementService;
        this._assetUriToAssetCache = new SimpleTimeBasedCacheImpl(invalidationIntervalMs, cacheCapacity);
        this._assetIdToAssetUriCache = new SimpleTimeBasedCacheImpl(invalidationIntervalMs, cacheCapacity);
        this._assetUriToLicenseUtilizationCache = new SimpleTimeBasedCacheImpl(invalidationIntervalMs, cacheCapacity);
    }

    public void invalidateCache() {
        this._assetUriToAssetCache.invalidate();
        this._assetIdToAssetUriCache.invalidate();
        this._assetUriToLicenseUtilizationCache.invalidate();
    }

    public ManagedObjectReference _getRef() {
        return this._assetManagementService._getRef();
    }

    public URI registerAsset(AssetRegisterSpec assetRegisterSpec) throws AlreadyExistsFault {
        URI assetUri = this._assetManagementService.registerAsset(assetRegisterSpec);
        AssetIdentifier assetIdentifier = assetRegisterSpec.getAssetIdentifier();
        this._assetIdToAssetUriCache.put((Object)new Pair((Object)assetIdentifier.getInstanceId(), (Object)assetIdentifier.getScopeId()), (Object)assetUri);
        return assetUri;
    }

    public void registerAsset(AssetRegisterSpec assetRegisterSpec, Future<URI> result) {
        try {
            URI assetUri = this.registerAsset(assetRegisterSpec);
            result.set((Object)assetUri);
        }
        catch (AlreadyExistsFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public Asset searchAsset(URI assetUri) throws NotFoundFault {
        AssetSearchSpecByIdsImpl spec = new AssetSearchSpecByIdsImpl();
        spec.setAssetIds(new URI[]{assetUri});
        Asset[] assets = this.searchAssetsByIdsCached((AssetSearchSpecByIds)spec);
        assert (assets != null && assets.length == 1);
        return assets[0];
    }

    public void searchAsset(URI assetUri, Future<Asset> result) {
        try {
            Asset asset = this.searchAsset(assetUri);
            result.set((Object)asset);
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public Asset searchAssetByIdentifier(AssetIdentifier assetIdentifier) throws NotFoundFault {
        AssetSearchSpecByIdentifiersImpl spec = new AssetSearchSpecByIdentifiersImpl();
        spec.setAssetIdentifiers(new AssetIdentifier[]{assetIdentifier});
        Asset[] assets = this.searchAssetsByIdentifiersCached((AssetSearchSpecByIdentifiers)spec);
        assert (assets != null && assets.length == 1);
        return assets[0];
    }

    public void searchAssetByIdentifier(AssetIdentifier assetIdentifier, Future<Asset> result) {
        try {
            Asset asset = this.searchAssetByIdentifier(assetIdentifier);
            result.set((Object)asset);
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public Asset[] searchAssets(AssetSearchSpec assetSearchSpec) throws NotFoundFault {
        Asset[] assets = null;
        if (assetSearchSpec instanceof AssetSearchSpecByIds) {
            assets = this.searchAssetsByIdsCached((AssetSearchSpecByIds)assetSearchSpec);
        } else if (assetSearchSpec instanceof AssetSearchSpecByIdentifiers) {
            assets = this.searchAssetsByIdentifiersCached((AssetSearchSpecByIdentifiers)assetSearchSpec);
        } else {
            assets = this._assetManagementService.searchAssets(assetSearchSpec);
            this.cacheAssets(assets);
        }
        return assets;
    }

    public void searchAssets(AssetSearchSpec assetSearchSpec, Future<Asset[]> result) {
        try {
            Asset[] assets = this.searchAssets(assetSearchSpec);
            result.set((Object)assets);
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public LicenseUtilization queryAssetLicenseUtilization(URI assetUri) throws NotFoundFault {
        LicenseUtilization licenseUtilization;
        if (this._assetUriToLicenseUtilizationCache.contains((Object)assetUri)) {
            licenseUtilization = (LicenseUtilization)this._assetUriToLicenseUtilizationCache.get((Object)assetUri);
        } else {
            licenseUtilization = this._assetManagementService.queryAssetLicenseUtilization(assetUri);
            this._assetUriToLicenseUtilizationCache.put((Object)assetUri, (Object)licenseUtilization);
        }
        return licenseUtilization;
    }

    public void queryAssetLicenseUtilization(URI assetUri, Future<LicenseUtilization> result) {
        try {
            LicenseUtilization licenseUtilization = this.queryAssetLicenseUtilization(assetUri);
            result.set((Object)licenseUtilization);
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public void updateAsset(URI assetUri, AssetUpdateSpec assetUpdateSpec) throws NotFoundFault {
        this._assetManagementService.updateAsset(assetUri, assetUpdateSpec);
        this.invalidateCachedAsset(assetUri);
    }

    public void updateAsset(URI assetUri, AssetUpdateSpec assetUpdateSpec, Future<Void> result) {
        try {
            this.updateAsset(assetUri, assetUpdateSpec);
            result.set();
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public void unregisterAsset(URI assetUri) throws NotFoundFault {
        this._assetManagementService.unregisterAsset(assetUri);
        this.invalidateCachedAsset(assetUri);
    }

    public void unregisterAsset(URI assetUri, Future<Void> result) {
        try {
            this.unregisterAsset(assetUri);
            result.set();
        }
        catch (NotFoundFault e) {
            result.setException((Exception)((Object)e));
        }
    }

    public void updateAssetLicense(URI assetUri, AssetUpdateLicenseSpec assetUpdateLicenseSpec) throws NotFoundFault, AlreadyExistsFault, AssignmentFault {
        throw new UnsupportedOperationException("Use SystemManagementService.updateAssetsLicense()");
    }

    public void updateAssetLicense(URI assetUri, AssetUpdateLicenseSpec assetUpdateLicenseSpec, Future<Void> result) {
        result.setException((Exception)new UnsupportedOperationException("Use SystemManagementService.updateAssetsLicense()"));
    }

    private Asset[] searchAssetsByIdsCached(AssetSearchSpecByIds spec) throws NotFoundFault {
        if (Util.isNullOrEmpty((Object[])spec.getAssetIds())) {
            return this._assetManagementService.searchAssets((AssetSearchSpec)spec);
        }
        LinkedHashMap<URI, Asset> resultAssets = new LinkedHashMap<URI, Asset>();
        ArrayList<URI> missingAssetUris = new ArrayList<URI>();
        for (URI assetUri : spec.getAssetIds()) {
            Asset asset = (Asset)this._assetUriToAssetCache.get((Object)assetUri);
            if (asset != null) {
                resultAssets.put(assetUri, asset);
                continue;
            }
            missingAssetUris.add(assetUri);
            resultAssets.put(assetUri, null);
        }
        Asset[] missingAssets = null;
        if (missingAssetUris.size() > 0) {
            AssetSearchSpecByIdsImpl missingIdsSpec = new AssetSearchSpecByIdsImpl();
            missingIdsSpec.setAssetIds(missingAssetUris.toArray(new URI[missingAssetUris.size()]));
            missingAssets = this._assetManagementService.searchAssets((AssetSearchSpec)missingIdsSpec);
            assert (missingAssets.length == missingAssetUris.size());
            this.cacheAssets(missingAssets);
            for (Asset missingAsset : missingAssets) {
                resultAssets.put(missingAsset.getId(), missingAsset);
            }
        }
        return resultAssets.values().toArray(new Asset[resultAssets.keySet().size()]);
    }

    private Asset[] searchAssetsByIdentifiersCached(AssetSearchSpecByIdentifiers spec) throws NotFoundFault {
        if (Util.isNullOrEmpty((Object[])spec.getAssetIdentifiers())) {
            return this._assetManagementService.searchAssets((AssetSearchSpec)spec);
        }
        LinkedHashMap<Pair, Asset> resultAssets = new LinkedHashMap<Pair, Asset>();
        ArrayList<AssetIdentifier> missingIdentifiers = new ArrayList<AssetIdentifier>();
        for (AssetIdentifier assetIdentifier : spec.getAssetIdentifiers()) {
            Pair assetIdPair = new Pair((Object)assetIdentifier.getInstanceId(), (Object)assetIdentifier.getScopeId());
            URI assetUri = (URI)this._assetIdToAssetUriCache.get((Object)assetIdPair);
            Asset asset = null;
            if (assetUri != null && (asset = (Asset)this._assetUriToAssetCache.get((Object)assetUri)) != null) {
                resultAssets.put(assetIdPair, asset);
            }
            if (asset != null) continue;
            missingIdentifiers.add(assetIdentifier);
            resultAssets.put(assetIdPair, null);
        }
        Asset[] missingAssets = null;
        if (missingIdentifiers.size() > 0) {
            AssetSearchSpecByIdentifiersImpl missingIdentifiersSpec = new AssetSearchSpecByIdentifiersImpl();
            missingIdentifiersSpec.setAssetIdentifiers(missingIdentifiers.toArray(new AssetIdentifier[missingIdentifiers.size()]));
            missingAssets = this._assetManagementService.searchAssets((AssetSearchSpec)missingIdentifiersSpec);
            assert (missingAssets.length == missingIdentifiers.size());
            this.cacheAssets(missingAssets);
            for (Asset missingAsset : missingAssets) {
                resultAssets.put(new Pair((Object)missingAsset.getInfo().getInstanceId(), (Object)missingAsset.getInfo().getScopeId()), missingAsset);
            }
        }
        return resultAssets.values().toArray(new Asset[resultAssets.keySet().size()]);
    }

    private void cacheAssets(Asset[] assets) {
        if (Util.isNullOrEmpty((Object[])assets)) {
            return;
        }
        for (Asset asset : assets) {
            this.cacheAsset(asset);
        }
    }

    private void cacheAsset(Asset asset) {
        assert (asset != null);
        this._assetUriToAssetCache.put((Object)asset.getId(), (Object)asset);
        this._assetIdToAssetUriCache.put((Object)new Pair((Object)asset.getInfo().getInstanceId(), (Object)asset.getInfo().getScopeId()), (Object)asset.getId());
    }

    private void invalidateCachedAsset(URI assetUri) {
        this._assetUriToAssetCache.invalidate((Object)assetUri);
        this._assetUriToLicenseUtilizationCache.invalidate((Object)assetUri);
    }
}

