/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.cis.license.client.impl.CacheLicenseClientImpl;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import java.net.URI;

public class CacheLicenseClientFactoryImpl
implements LicenseClientFactory {
    private static final long DEFAULT_INVALIDATION_INTERVAL_MS = 600000L;
    private static final int DEFAULT_MAX_CACHE_OBJECTS = 1500;
    private final LicenseClientFactory _licenseClientFactory;
    private final long _invalidationIntervalMs;
    private final int _cacheCapacity;

    public CacheLicenseClientFactoryImpl(LicenseClientFactory licenseClientFactory) {
        this(licenseClientFactory, 600000L, 1500);
    }

    public CacheLicenseClientFactoryImpl(LicenseClientFactory licenseClientFactory, long invalidationIntervalMs, int cacheCapacity) {
        this._licenseClientFactory = licenseClientFactory;
        this._invalidationIntervalMs = invalidationIntervalMs;
        this._cacheCapacity = cacheCapacity;
    }

    @Override
    public LicenseClient createClient(URI lsUri, HttpConfiguration httpConfig) {
        LicenseClient licenseClient = this._licenseClientFactory.createClient(lsUri, httpConfig);
        return this.createCachedClient(licenseClient);
    }

    @Override
    public LicenseClient createClient(ServerEndpointProvider lsUriProvider, HttpConfiguration httpConfig) {
        LicenseClient licenseClient = this._licenseClientFactory.createClient(lsUriProvider, httpConfig);
        return this.createCachedClient(licenseClient);
    }

    private LicenseClient createCachedClient(LicenseClient licenseClient) {
        return new CacheLicenseClientImpl(licenseClient, this._invalidationIntervalMs, this._cacheCapacity);
    }
}

