/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.model;

import com.vmware.cis.data.model.Property;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;

public abstract class ProviderSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="ProviderSummaryData/usedCpuCapacity")
    private long cpuUsageMhz;
    @Property(value="ProviderSummaryData/totalCpuCapacity")
    private long cpuTotalMhz;
    @Property(value="ProviderSummaryData/usedMemoryCapacity")
    private long memoryUsageB;
    @Property(value="ProviderSummaryData/totalMemoryCapacity")
    private long memoryTotalB;
    @Property(value="ProviderSummaryData/usedStorageCapacity")
    private long storageUsageB;
    @Property(value="ProviderSummaryData/totalStorageCapacity")
    private long storageTotalB;

    @Override
    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeCpu = FormatUtil.getFrequencyFormatted((Number)Math.abs(this.cpuTotalMhz - this.cpuUsageMhz), (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String usedCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuUsageMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String capacityCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuTotalMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String freeMemory = FormatUtil.getStorageFormatted((Long)Math.abs(this.memoryTotalB - this.memoryUsageB), (long)1L, (long)-1L);
        String usedMemory = FormatUtil.getStorageFormatted((Long)this.memoryUsageB, (long)1L, (long)-1L);
        String capacityMemory = FormatUtil.getStorageFormatted((Long)this.memoryTotalB, (long)1L, (long)-1L);
        String freeStorage = FormatUtil.getStorageFormatted((Long)Math.abs(this.storageTotalB - this.storageUsageB), (long)1L, (long)-1L);
        String usedStorage = FormatUtil.getStorageFormatted((Long)this.storageUsageB, (long)1L, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)this.storageTotalB, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("CpuResourceDataItem.CpuLabel", freeCpu, usedCpu, capacityCpu, Util.getPercentageUsage(this.cpuUsageMhz, this.cpuTotalMhz)), new ResourceMeterData.ResourceMeter("MemoryResourceDataItem.MemoryLabel", freeMemory, usedMemory, capacityMemory, Util.getPercentageUsage(this.memoryUsageB, this.memoryTotalB)), new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, Util.getPercentageUsage(this.storageUsageB, this.storageTotalB))};
    }
}

