/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VmHostMigrateFilterBuilder
implements QueryFilterBuilder {
    private static final String VM_DATASTORES_PROPERTY = "vmDatastoresInfo";
    private static final String HOSTSYSTEM_STORAGE = "HostSystem/storage";
    private static final String CLUSTER_STORAGE = "ClusterComputeResource/storage";
    private static final String RESOURCEPOOL_STORAGE = "ResourcePool/storage";
    private static final String VIRTUALAPP_STORAGE = "VirtualApp/storage";
    private final QueryServiceFactory _factory;
    private final ObjectReferenceService _objectReferenceService;

    public VmHostMigrateFilterBuilder(QueryServiceFactory factory, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{factory, objectReferenceService});
        this._factory = factory;
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="vmMigrationHostFilter")
    public Filter vmMigrationHostFilter(String vmId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        Object vmRef = this._objectReferenceService.getReference(vmId, true);
        if (vmRef == null) {
            return null;
        }
        PropertyPredicate predicate = this.createDatastorePredicate(vmRef, HOSTSYSTEM_STORAGE);
        return new Filter(Collections.singletonList(predicate));
    }

    @QueryFilter(value="vmMigrationClusterFilter")
    public Filter vmMigrationClusterFilter(String vmId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        Object vmRef = this._objectReferenceService.getReference(vmId, true);
        if (vmRef == null) {
            return null;
        }
        PropertyPredicate predicate = this.createDatastorePredicate(vmRef, CLUSTER_STORAGE);
        return new Filter(Collections.singletonList(predicate));
    }

    @QueryFilter(value="vmMigrationResourcePoolFilter")
    public Filter vmMigrationResourcePoolFilter(String vmId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        Object vmRef = this._objectReferenceService.getReference(vmId, true);
        if (vmRef == null) {
            return null;
        }
        PropertyPredicate dsPredicate = this.createDatastorePredicate(vmRef, RESOURCEPOOL_STORAGE);
        PropertyPredicate rootResourcePoolPredicate = new PropertyPredicate("isRootRP", PropertyPredicate.ComparisonOperator.EQUAL, (Object)false);
        return new Filter(Arrays.asList(dsPredicate, rootResourcePoolPredicate));
    }

    @QueryFilter(value="vmMigrationVirtualAppFilter")
    public Filter vmMigrationVirtualAppFilter(String vmId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmId});
        Object vmRef = this._objectReferenceService.getReference(vmId, true);
        if (vmRef == null) {
            return null;
        }
        PropertyPredicate predicate = this.createDatastorePredicate(vmRef, VIRTUALAPP_STORAGE);
        return new Filter(Collections.singletonList(predicate));
    }

    private PropertyPredicate createDatastorePredicate(Object vmRef, String storageProperty) {
        List<ManagedObjectReference> dsRefs = this.fetchDatastoreRefs(vmRef);
        PropertyPredicate predicate = new PropertyPredicate(storageProperty, PropertyPredicate.ComparisonOperator.IN, dsRefs);
        return predicate;
    }

    private List<ManagedObjectReference> fetchDatastoreRefs(Object vmRef) {
        QueryService queryService = this._factory.getQueryService();
        ResultSet result = queryService.select(new String[]{VM_DATASTORES_PROPERTY}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, vmRef).fetch();
        List resultItems = result.getItems();
        if (resultItems.isEmpty()) {
            return Collections.emptyList();
        }
        ResourceItem item = (ResourceItem)resultItems.get(0);
        DatastoreMirrorsInfo[] dsMirrorsInfo = (DatastoreMirrorsInfo[])item.getPropertyValues().get(0);
        ArrayList<ManagedObjectReference> dsRefs = new ArrayList<ManagedObjectReference>();
        for (DatastoreMirrorsInfo dmi : dsMirrorsInfo) {
            dsRefs.add(dmi.ref);
        }
        return dsRefs;
    }
}

