/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceIconData;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.commonservice.util.VmToolsUtil;
import java.util.ArrayList;

@QueryBinding(value="VirtualMachine")
public final class VmSummaryData
extends BaseSummaryData
implements ResourceIconData {
    @Property(value="VirtualMachine/name")
    public String name;
    @Property(value="VirtualMachine/guest/hostName")
    private String dnsNameInternal;
    @Property(value="VirtualMachine/vmIpAddressList")
    private String[] ipAddressesInternal;
    @Property(value="VirtualMachine/runtime/powerState")
    public VirtualMachine.PowerState powerState;
    @Property(value="VirtualMachine/guest/guestFullName")
    private String guestFullNameFromGuestInfo;
    @Property(value="VirtualMachine/config/guestFullName")
    private String guestFullNameFromConfigInfo;
    @Property(value="VirtualMachine/effectiveGuestOsFamily")
    public String guestOsFamilyKey;
    @Property(value="VirtualMachine/config/version")
    private String hwVersion;
    @Relationship(value={"VirtualMachine/runtime/host"})
    @Property(value="VirtualMachine/name")
    private String hostName;
    @Property(value="VirtualMachine/toolsRunningStatus")
    private String toolsRunningStatus;
    @Property(value="VirtualMachine/detailedToolsVersionStatus")
    private String detailedToolsVersionStatus;
    @Property(value="VirtualMachine/summary/quickStats/guestMemoryUsage")
    public long memoryUsageMb;
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    public int cpuUsageMhz;
    @Property(value="VirtualMachine/summary/storage/committed")
    public long storageUsageB;
    @Property(value="VirtualMachine/config/template")
    public boolean isTemplate;
    VmToolsUtil toolsutil = new VmToolsUtil();

    private String[] getIpAddress() {
        if (this.ipAddressesInternal == null || this.ipAddressesInternal.length == 0 || this.ipAddressesInternal[0] == null) {
            return new String[0];
        }
        return this.ipAddressesInternal;
    }

    private String getDnsName() {
        if (this.dnsNameInternal == null || this.dnsNameInternal.length() == 0) {
            return "";
        }
        return this.dnsNameInternal;
    }

    private String getGuestFullName() {
        if (this.guestFullNameFromGuestInfo != null && this.guestFullNameFromGuestInfo.length() > 0) {
            return this.guestFullNameFromGuestInfo;
        }
        return this.guestFullNameFromConfigInfo;
    }

    private String getHwVersion() {
        if (this.hwVersion == null) {
            return "";
        }
        return Util.getLocalizedString("VmHardware.HWVersion.long." + this.hwVersion);
    }

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summaryView.guestFullName", this.getGuestFullName()), new BaseSummaryData.LabelValue("summaryView.vmVersion", this.getHwVersion()), new BaseSummaryData.LabelValue("summaryView.tools", this.toolsutil.getVersionStatus(this.toolsRunningStatus, this.detailedToolsVersionStatus)), new BaseSummaryData.LabelValue("summaryView.dnsNameLabel", this.getDnsName()), new BaseSummaryData.LabelValue("summaryView.ipAddressLabel", this.getIpAddress()), new BaseSummaryData.LabelValue("summaryView.hostLabel", this.hostName)};
    }

    @Override
    public ResourceIconData.ResourceIcon[] getResourceIcons() {
        String storageUsed = FormatUtil.getStorageFormatted((Long)this.storageUsageB, (long)1L, (long)-1L);
        String cpuUsed = FormatUtil.getFrequencyFormatted((Number)this.cpuUsageMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String memoryUsed = FormatUtil.getStorageFormatted((Long)this.memoryUsageMb, (long)0x100000L, (long)-1L);
        if (this.isTemplate) {
            return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.storageUsage", storageUsed, "vsphere-icon-storage-summary")};
        }
        return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.cpuUsage", cpuUsed, "vsphere-icon-cpu-summary"), new ResourceIconData.ResourceIcon("summary.memoryUsage", memoryUsed, "vsphere-icon-memory-summary"), new ResourceIconData.ResourceIcon("summary.storageUsage", storageUsed, "vsphere-icon-storage-summary")};
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.guestOsFamilyKey == null) {
            return result.toArray(new BaseSummaryData.Badge[result.size()]);
        }
        switch (this.guestOsFamilyKey) {
            case "windowsGuest": {
                result.add(new BaseSummaryData.Badge("windows-icon", "VmOptionsView.General.GosFamily.Windows", false));
                break;
            }
            case "linuxGuest": {
                result.add(new BaseSummaryData.Badge("linux-icon", "VmOptionsView.General.GosFamily.Linux", false));
                break;
            }
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }
}

