/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

public final class BuildProperties {
    private static final String BUILD_PROPERTIES_FILE = "java-util-build.properties";
    private static final Properties PROPERTIES;

    public static boolean isH5Client() {
        return Boolean.parseBoolean(PROPERTIES.getProperty("build.isH5Client"));
    }

    public static String getXsrfCookieName() {
        return PROPERTIES.getProperty("build.xsrf.cookie.name");
    }

    public static String getXsrfHeaderName() {
        return PROPERTIES.getProperty("build.xsrf.header.name");
    }

    public static boolean isReleaseBuild() {
        return "release".equals(PROPERTIES.getProperty("build.type"));
    }

    static {
        ClassPathResource classPathResource = new ClassPathResource(BUILD_PROPERTIES_FILE, BuildProperties.class.getClassLoader());
        PROPERTIES = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = classPathResource.getInputStream();
            PROPERTIES.load(inputStream);
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
        finally {
            StreamUtil.close(inputStream);
        }
    }
}

