/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.internal.Config;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class OpIdUtil {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_OP_ID_PREFIX;
    private static final AtomicLong _opCount;
    private static final ThreadLocal<String> _customOpIdPrefix;

    public static String generateOpId() {
        String string = _customOpIdPrefix.get();
        if (string == null) {
            string = OpIdUtil.getOpIdFromRequest();
        }
        if (string == null) {
            string = DEFAULT_OP_ID_PREFIX;
        }
        return string + "-" + _opCount.incrementAndGet() + "-ngc";
    }

    public static String generateOpId(String string) {
        Assert.notNull((Object)string, (String)"suffix must not be null");
        return OpIdUtil.generateOpId() + string;
    }

    public static String generateFlexOpId() {
        String string = _customOpIdPrefix.get();
        if (string == null) {
            string = DEFAULT_OP_ID_PREFIX;
        }
        return string + "-amf-auto-" + _opCount.incrementAndGet();
    }

    public static String getOpIdFromRequest() {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            return null;
        }
        return OpIdUtil.getOpIdFromRequest(httpServletRequest);
    }

    public static String getOpIdFromRequest(HttpServletRequest httpServletRequest) {
        Validate.notNull((Object)httpServletRequest);
        Object object = httpServletRequest.getAttribute("opId");
        return (String)object;
    }

    public static void setOpIdIntoRequest(String string) {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest != null) {
            OpIdUtil.setOpIdIntoRequest(httpServletRequest, string);
        }
    }

    public static void setOpIdIntoRequest(HttpServletRequest httpServletRequest, String string) {
        Validate.notNull((Object)httpServletRequest);
        httpServletRequest.setAttribute("opId", (Object)string);
    }

    public static void setCustomOpIdPrefix(String string) {
        _customOpIdPrefix.set(string);
    }

    public static String getCustomOpIdPrefix() {
        String string = _customOpIdPrefix.get();
        return string;
    }

    public static LogUtil.LogLevel determineLogLevelFor(Log log, Method method) {
        if (log == null) {
            return LogUtil.LogLevel.OFF;
        }
        Validate.notNull((Object)method);
        String string = method.getDeclaringClass().getName();
        String string2 = method.getName();
        Pair<String, String> pair = new Pair<String, String>(string, string2);
        if (Config.OP_ID_LOGGING_METHODS_TRACE_LEVEL.contains(pair)) {
            if (log.isTraceEnabled()) {
                return LogUtil.LogLevel.TRACE;
            }
            return LogUtil.LogLevel.OFF;
        }
        if (log.isDebugEnabled()) {
            return LogUtil.LogLevel.DEBUG;
        }
        return LogUtil.LogLevel.OFF;
    }

    public static boolean shouldSlowInvocationBeLogged(Method method) {
        Validate.notNull((Object)method);
        String string = method.getDeclaringClass().getName();
        String string2 = method.getName();
        Pair<String, String> pair = new Pair<String, String>(string, string2);
        boolean bl = !Config.OP_ID_LOGGING_METHODS_WHITELIST_SLOW.contains(pair);
        return bl;
    }

    static {
        _opCount = new AtomicLong();
        _customOpIdPrefix = new ThreadLocal();
        DEFAULT_OP_ID_PREFIX = UUID.randomUUID().toString();
        _logger.info((Object)("Generated DEFAULT_OP_ID_PREFIX: " + DEFAULT_OP_ID_PREFIX));
    }
}

