/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.StringUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.springframework.util.StringUtils;

public final class ValidationUtil {
    public static void paramsNotNull(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Null argument args");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Null param at index: " + i);
        }
    }

    public static void stringsNotNullOrEmpty(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null argument strs");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringUtil.isNullOrEmpty(stringArray[i])) continue;
            throw new IllegalArgumentException("Null or empty string param at index: " + i);
        }
    }

    public static <T> T notNull(T t) {
        return ValidationUtil.notNull(t, "The validated object is null");
    }

    public static <T> T notNull(T t, String string) {
        if (t == null) {
            throw new IllegalArgumentException(string);
        }
        return t;
    }

    public static void noNullOrWhitespaceElements(@Nonnull String[] stringArray, boolean bl) {
        if (bl) {
            Validate.notNull((Object)stringArray, (String)"The array is null");
        } else {
            Validate.notEmpty((Object[])stringArray, (String)"The array is null or empty");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                throw new IllegalArgumentException("A null element at index " + i + ": " + Arrays.toString(stringArray));
            }
            if (!StringUtils.hasText((String)string)) {
                throw new IllegalArgumentException("An empty or whitespace-only element at index " + i + ": " + Arrays.toString(stringArray));
            }
            stringArray[i] = string;
        }
    }
}

