/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLInputFactorySource;
import com.vmware.vise.util.io.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static final Log _logger = LogFactory.getLog(XMLUtil.class);
    private static final XPath _xpath = XPathFactory.newInstance().newXPath();
    private static final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private static final XMLInputFactorySource _xmlInputFactorySource = XMLInputFactorySource.INSTANCE;
    private static final String UTF_8_ENCODING = "UTF-8";
    private static HashMap<Class<?>, Unmarshaller> _unmarshallersByClass = new HashMap();
    private static XMLInputFactory _xmlInputFactory = null;

    public static Document loadXmlFile(String string) throws ParserConfigurationException, IOException, SAXException {
        File file = new File(string);
        Document document = XMLUtil.loadXmlFile(file);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXmlFile(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        try {
            Document document;
            DocumentBuilder documentBuilder = _builderFactorySource.createDocumentBuilder();
            Document document2 = document = documentBuilder.parse(inputStream);
            return document2;
        }
        finally {
            StreamUtil.close(inputStream);
        }
    }

    public static Document loadXmlFile(File file) throws ParserConfigurationException, IOException, SAXException {
        if (file == null) {
            return null;
        }
        URL uRL = file.toURI().toURL();
        Document document = XMLUtil.loadXmlFile(uRL);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXmlFile(URL uRL) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        InputStream inputStream = null;
        try {
            Document document2;
            DocumentBuilder documentBuilder = _builderFactorySource.createDocumentBuilder();
            inputStream = uRL.openStream();
            document = document2 = documentBuilder.parse(inputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.close(inputStream);
            throw throwable;
        }
        StreamUtil.close(inputStream);
        return document;
    }

    public static Document parseXml(String string) {
        try {
            DocumentBuilder documentBuilder = _builderFactorySource.createDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            return document;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when loading xml string", (Throwable)exception);
            return null;
        }
    }

    public static String xmlToString(Node node) throws IOException {
        return XMLUtil.xmlToString(node, false);
    }

    public static String xmlToString(Node node, boolean bl) throws IOException {
        String string = "javax.xml.transform.TransformerFactory";
        String string2 = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
        String string3 = System.getProperty(string);
        if (string3 == null) {
            System.setProperty(string, string2);
        }
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xslTransform(String string, InputStream inputStream) throws TransformerException, TransformerConfigurationException {
        if (string == null || inputStream == null) {
            return string;
        }
        StreamSource streamSource = new StreamSource(inputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        StringReader stringReader = new StringReader(string);
        StreamSource streamSource2 = new StreamSource(stringReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        String string2 = "";
        try {
            transformer.transform(streamSource2, streamResult);
            string2 = byteArrayOutputStream.toString(UTF_8_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _logger.error((Object)unsupportedEncodingException);
            string2 = byteArrayOutputStream.toString();
        }
        finally {
            stringReader.close();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettyFormatXml(File file) throws Exception {
        Document document = XMLUtil.loadXmlFile(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", UTF_8_ENCODING);
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult streamResult = null;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, false);
            streamResult = new StreamResult(fileWriter);
            transformer.transform(new DOMSource(document), streamResult);
            fileWriter.flush();
        }
        catch (Throwable throwable) {
            StreamUtil.close(fileWriter);
            StreamUtil.close(streamResult.getOutputStream());
            throw throwable;
        }
        StreamUtil.close(fileWriter);
        StreamUtil.close(streamResult.getOutputStream());
    }

    public static String getAttribute(Element element, String string) {
        ValidationUtil.paramsNotNull(element, string);
        String string2 = element.getAttribute(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static boolean getBooleanAttribute(Element element, String string, boolean bl) {
        ValidationUtil.paramsNotNull(element, string);
        String string2 = XMLUtil.getAttribute(element, string);
        if (string2 != null) {
            if (string2.equals("true")) {
                return true;
            }
            if (string2.equals("false")) {
                return false;
            }
        }
        return bl;
    }

    public static Element getChildTag(Node node, String string) {
        ValidationUtil.paramsNotNull(node, string);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return (Element)node2;
        }
        return null;
    }

    public static List<Element> getChildTags(Node node, String string) {
        ValidationUtil.paramsNotNull(node, string);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public static String getChildTagValue(Node node, String string) {
        ValidationUtil.paramsNotNull(node);
        Element element = XMLUtil.getChildTag(node, string);
        if (element == null) {
            return null;
        }
        String string2 = XMLUtil.getTagValue(element);
        return string2;
    }

    public static String getTagValue(Element element) {
        ValidationUtil.paramsNotNull(element);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        String string = null;
        if (n == 1) {
            string = element.getFirstChild().getNodeValue();
        } else if (n != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string2 = nodeList.item(i).getNodeValue();
                if (string2 == null) continue;
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static void addChildTags(Node node, Node node2) {
        ValidationUtil.paramsNotNull(node, node2);
        NodeList nodeList = node.getChildNodes();
        Document document = node2.getOwnerDocument();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            Node node4 = document.importNode(node3, true);
            node2.appendChild(node4);
        }
    }

    public static String valueForTagInNode(Node node, String string, boolean bl) {
        ValidationUtil.paramsNotNull(node, string);
        Node node2 = XMLUtil.selectSingleNode((Element)node, "./" + string);
        if (node2 == null) {
            if (!bl) {
                throw new IllegalStateException("required element not found: " + string);
            }
            return null;
        }
        String string2 = node2.getTextContent();
        return string2;
    }

    public static String[] valuesForTagInNode(Node node, String string, boolean bl) {
        ValidationUtil.paramsNotNull(node, string);
        NodeList nodeList = XMLUtil.selectNodes((Element)node, "./" + string);
        if (nodeList == null) {
            if (!bl) {
                throw new IllegalStateException("required element not found: " + string);
            }
            return new String[0];
        }
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringArray[i] = nodeList.item(i).getTextContent();
        }
        return stringArray;
    }

    public static String getParentAttribute(Node node, String string) {
        ValidationUtil.paramsNotNull(node, string);
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node3 = namedNodeMap.getNamedItem(string);
        if (node3 == null) {
            return null;
        }
        String string2 = node3.getNodeValue();
        return string2;
    }

    public static String escapeXmlTag(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("[", "_ob_");
        string = string.replace("]", "_cb_");
        string = string.replace("@", "_at_");
        string = string.replace("=", "_eq_");
        string = string.replace("'", "_sq_");
        string = string.replace("\"", "_dq_");
        string = string.replace("/", "_sl_");
        return string;
    }

    public static String unescapeXmlTag(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("_ob_", "[");
        string = string.replace("_cb_", "]");
        string = string.replace("_at_", "@");
        string = string.replace("_eq_", "=");
        string = string.replace("_sq_", "'");
        string = string.replace("_dq_", "\"");
        string = string.replace("_sl_", "/");
        return string;
    }

    public static NodeList selectNodes(Element element, String string) {
        ValidationUtil.paramsNotNull(element, string);
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)_xpath.evaluate(string, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return nodeList;
    }

    public static Node selectSingleNode(Element element, String string) {
        ValidationUtil.paramsNotNull(element, string);
        Node node = null;
        try {
            NodeList nodeList = (NodeList)_xpath.evaluate(string, element, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                node = nodeList.item(0);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return node;
    }

    public static <T> T createObjectFromXml(String string, Class<T> clazz) throws Exception {
        StringBuffer stringBuffer;
        Object object = null;
        Unmarshaller unmarshaller = _unmarshallersByClass.get(clazz);
        if (unmarshaller == null) {
            stringBuffer = JAXBContext.newInstance((Class[])new Class[]{clazz});
            unmarshaller = stringBuffer.createUnmarshaller();
            _unmarshallersByClass.put(clazz, unmarshaller);
        }
        if (_xmlInputFactory == null) {
            _xmlInputFactory = _xmlInputFactorySource.createXMLInputFactory();
        }
        stringBuffer = new StringBuffer(string);
        XMLStreamReader xMLStreamReader = _xmlInputFactory.createXMLStreamReader(new StringReader(stringBuffer.toString()));
        xMLStreamReader = new CustomStreamReaderDelegate(xMLStreamReader);
        object = unmarshaller.unmarshal(xMLStreamReader);
        return (T)object;
    }

    public static <T> T createObjectFromNode(Node node, Class<T> clazz) throws JAXBException {
        Object object;
        ValidationUtil.paramsNotNull(node, clazz);
        Unmarshaller unmarshaller = _unmarshallersByClass.get(clazz);
        if (unmarshaller == null) {
            object = JAXBContext.newInstance((Class[])new Class[]{clazz});
            unmarshaller = object.createUnmarshaller();
            _unmarshallersByClass.put(clazz, unmarshaller);
        }
        object = unmarshaller.unmarshal(node);
        return (T)object;
    }

    private static class CustomNamespaceContext
    implements NamespaceContext {
        public NamespaceContext _context;

        public CustomNamespaceContext(NamespaceContext namespaceContext) {
            this._context = namespaceContext;
        }

        public Iterator<?> getPrefixes(String string) {
            return this._context.getPrefixes(string);
        }

        @Override
        public String getPrefix(String string) {
            return this._context.getPrefix(string);
        }

        @Override
        public String getNamespaceURI(String string) {
            if ("xs".equals(string)) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            return this._context.getNamespaceURI(string);
        }
    }

    private static class CustomStreamReaderDelegate
    extends StreamReaderDelegate {
        public CustomStreamReaderDelegate(XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
        }

        @Override
        public String getAttributeNamespace(int n) {
            String string = this.getAttributeLocalName(n);
            if ("type".equals(string)) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            return super.getAttributeNamespace(n);
        }

        @Override
        public String getAttributeValue(int n) {
            String string = this.getAttributeLocalName(n);
            if ("type".equals(string)) {
                String string2 = super.getAttributeValue(n);
                return "xs:" + string2;
            }
            return super.getAttributeValue(n);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return new CustomNamespaceContext(super.getNamespaceContext());
        }
    }
}

