/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.cache;

import com.vmware.vise.util.cache.ContainerService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContainerServiceImpl
implements ContainerService {
    private static final Log _logger = LogFactory.getLog(ContainerServiceImpl.class);
    private final ConcurrentMap<Class<?>, ContainerWrapper<?>> _wrapperByType = new ConcurrentHashMap();

    @Override
    public <T> T getContainer(Class<T> clazz) {
        Future future;
        T t;
        if (clazz == null) {
            return null;
        }
        ContainerWrapper containerWrapper = (ContainerWrapper)this._wrapperByType.get(clazz);
        T t2 = t = containerWrapper != null ? (T)clazz.cast(containerWrapper.lastComputedState) : null;
        if (t != null) {
            return t;
        }
        if (containerWrapper != null && (future = containerWrapper.task) != null) {
            try {
                return clazz.cast(future.get());
            }
            catch (CancellationException cancellationException) {
                _logger.warn((Object)"Future task was canceled, so result can not be obtained");
            }
            catch (Exception exception) {
                _logger.error((Object)"Error while executing the task", (Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public <T> boolean putContainer(Class<T> clazz, Callable<T> callable) throws InterruptedException {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        boolean bl = this.initialize(clazz, futureTask);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean initialize(Class<T> clazz, FutureTask<T> futureTask) throws InterruptedException {
        boolean bl = false;
        if (clazz == null || futureTask == null) {
            return false;
        }
        ContainerWrapper<T> containerWrapper = this.getContainerWrapper(clazz);
        int n = containerWrapper.currentVersion.incrementAndGet();
        futureTask.run();
        containerWrapper.task = futureTask;
        Object var6_6 = null;
        try {
            var6_6 = futureTask.get();
        }
        catch (CancellationException cancellationException) {
            _logger.warn((Object)"Future task was canceled, so result can not be obtained");
        }
        catch (ExecutionException executionException) {
            _logger.error((Object)"Error in executing future task", (Throwable)executionException);
            throw ContainerServiceImpl.handleException(executionException.getCause());
        }
        if (var6_6 != null) {
            ContainerWrapper<T> containerWrapper2 = containerWrapper;
            synchronized (containerWrapper2) {
                if (n > containerWrapper.lastComputedVersion) {
                    containerWrapper.lastComputedState = var6_6;
                    containerWrapper.lastComputedVersion = n;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private <T> ContainerWrapper<T> getContainerWrapper(Class<T> clazz) {
        ContainerWrapper containerWrapper;
        ContainerWrapper containerWrapper2 = (ContainerWrapper)this._wrapperByType.get(clazz);
        if (containerWrapper2 == null && (containerWrapper2 = this._wrapperByType.putIfAbsent(clazz, containerWrapper = new ContainerWrapper())) == null) {
            containerWrapper2 = containerWrapper;
        }
        return containerWrapper2;
    }

    private static RuntimeException handleException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalStateException("Not unchecked", throwable);
    }

    private static class ContainerWrapper<T> {
        volatile Future<T> task;
        volatile T lastComputedState;
        int lastComputedVersion;
        AtomicInteger currentVersion = new AtomicInteger(0);

        private ContainerWrapper() {
        }
    }
}

