/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.client.configuration;

import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.client.configuration.ConfigurationLocator;
import com.vmware.vise.util.client.configuration.ConfigurationPayload;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureStateProvider;
import com.vmware.vise.util.io.StreamUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final String WARNING_TEXT = "#***WARNING*** THIS PROPERTY IS DEPRECATED";
    private final AtomicReference<PropertiesData> _propertiesDataRef = new AtomicReference();
    private final ConfigurationLocator _configurationLocator;
    private final FeatureStateProvider _featureStateProvider;
    private final File _webPropertiesFile;
    private static final String[] DEPRECATED_PROPERTIES = new String[]{"sso.enabled"};
    private static final Log _logger = LogFactory.getLog(ConfigurationServiceImpl.class);

    public ConfigurationServiceImpl(ConfigurationLocator configurationLocator, FeatureStateProvider featureStateProvider) {
        Validate.notNull((Object)configurationLocator);
        Validate.notNull((Object)featureStateProvider);
        this._configurationLocator = configurationLocator;
        this._webPropertiesFile = new File(this._configurationLocator.getConfigFilePath());
        this._featureStateProvider = featureStateProvider;
        ConfigurationServiceImpl.removeDeprecatedProperties(this._webPropertiesFile);
        this.loadProperties();
    }

    private synchronized void loadProperties() {
        PropertiesData propertiesData = this._propertiesDataRef.get();
        if (this._webPropertiesFile == null || !this._webPropertiesFile.isFile() || propertiesData != null && propertiesData.lastModified == this._webPropertiesFile.lastModified()) {
            return;
        }
        Properties properties = this._configurationLocator.getDefaultProperties();
        _logger.info((Object)String.format("Reloading config file: %s", this._webPropertiesFile));
        ConfigurationServiceImpl.loadConfigFile(this._webPropertiesFile, properties);
        propertiesData = new PropertiesData(properties, this._webPropertiesFile.lastModified());
        this._propertiesDataRef.set(propertiesData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDeprecatedProperties(File file) {
        if (file == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        FileInputStream fileInputStream = null;
        File file2 = null;
        boolean bl = false;
        try {
            file2 = File.createTempFile(file.getName(), null);
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null) continue;
                string = string.trim();
                for (String string2 : DEPRECATED_PROPERTIES) {
                    String string3 = string2.replace(".", "\\.") + "\\s*=.*";
                    if (string.matches(string3)) {
                        string = "#***WARNING*** THIS PROPERTY IS DEPRECATED\n#" + string;
                        _logger.info((Object)(string2 + " has been removed from " + file.getName()));
                        continue;
                    }
                    if (bl || !string.matches("#\\s*" + string3)) continue;
                    string = "#***WARNING*** THIS PROPERTY IS DEPRECATED\n" + string;
                    _logger.info((Object)(string2 + " has been marked deprecated in " + file.getName()));
                }
                bl = string.equals(WARNING_TEXT);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)("Exception occured while cleaning " + file.getName() + " of deprecated properties"), (Throwable)exception);
            }
            catch (Throwable throwable) {
                StreamUtil.close(bufferedReader);
                StreamUtil.close(bufferedWriter);
                throw throwable;
            }
            StreamUtil.close(bufferedReader);
            StreamUtil.close(bufferedWriter);
            return;
        }
        StreamUtil.close(bufferedReader);
        StreamUtil.close(bufferedWriter);
        try {
            fileInputStream = new FileInputStream(file2);
            FileUtil.writeFile(fileInputStream, file);
            file2.delete();
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)("Exception occured while copying temp file to " + file.getName()), (Throwable)exception);
            }
            catch (Throwable throwable) {
                StreamUtil.close(fileInputStream);
                throw throwable;
            }
            StreamUtil.close(fileInputStream);
        }
        StreamUtil.close(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadConfigFile(File file, Properties properties) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            _logger.warn((Object)("Could not find properties file with filename " + file.getName()));
            StreamUtil.close(fileInputStream);
        }
        catch (Exception exception) {
            _logger.warn((Object)("Unhandled exception loading properties file " + file.getName()));
            {
                catch (Throwable throwable) {
                    StreamUtil.close(fileInputStream);
                    throw throwable;
                }
            }
            StreamUtil.close(fileInputStream);
        }
        StreamUtil.close(fileInputStream);
    }

    @Override
    public String getProperty(String string) {
        PropertiesData propertiesData = this._propertiesDataRef.get();
        if (this._webPropertiesFile != null && this._webPropertiesFile.isFile() && this._webPropertiesFile.lastModified() != propertiesData.lastModified) {
            this.loadProperties();
            propertiesData = this._propertiesDataRef.get();
        }
        return (String)propertiesData.map.get(string);
    }

    @Override
    public Map<Object, Object> getAllProperties() {
        return this.getAllPropertiesInternal();
    }

    private Map<Object, Object> getAllPropertiesInternal() {
        PropertiesData propertiesData = this._propertiesDataRef.get();
        if (this._webPropertiesFile != null && this._webPropertiesFile.isFile() && this._webPropertiesFile.lastModified() != propertiesData.lastModified) {
            this.loadProperties();
            propertiesData = this._propertiesDataRef.get();
        }
        return Collections.unmodifiableMap(propertiesData.map);
    }

    @Override
    public ConfigurationPayload getConfiguration() {
        ConfigurationPayload configurationPayload = new ConfigurationPayload();
        configurationPayload.configParams = this.getAllPropertiesInternal();
        configurationPayload.featureStates = this._featureStateProvider.getAllFeatures();
        return configurationPayload;
    }

    @Override
    public void addProperty(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        PropertiesData propertiesData = this._propertiesDataRef.get();
        propertiesData.setProperty(string, string2);
        String string3 = "\r\n" + string + "=" + string2;
        byte[] byArray = string3.getBytes();
        Path path = this._webPropertiesFile.toPath();
        try {
            Files.write(path, byArray, StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            _logger.error((Object)("Could not add a property to the config file. PropertyName:" + string));
        }
    }

    private class PropertiesData {
        final Map<Object, Object> map;
        final long lastModified;

        PropertiesData(Properties properties, long l) {
            this.map = new HashMap<Object, Object>(properties);
            this.lastModified = l;
        }

        void setProperty(String string, String string2) {
            this.map.put(string, string2);
        }
    }
}

