/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.collection;

import com.vmware.vise.util.Merger;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> Set<T> filter(Collection<T> collection, Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        HashSet<T> hashSet = new HashSet<T>();
        if (collection == null) {
            return hashSet;
        }
        for (T t : collection) {
            if (!predicate.evaluate(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> List<T> filterToList(Collection<T> collection, Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        if (collection == null) {
            return linkedList;
        }
        for (T t : collection) {
            if (!predicate.evaluate(t)) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static <T> Collection<T> intersection(Collection<T> collection, Collection<T> collection2) {
        if (collection == null || collection2 == null) {
            return collection == null ? collection2 : collection;
        }
        Set<T> set = CollectionUtil.toSet(collection);
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection2) {
            if (!set.contains(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> List<T> removeDuplicates(Collection<T> collection) {
        return CollectionUtil.mergeDuplicates(collection, null, null);
    }

    public static <T> List<T> removeDuplicates(Collection<T> collection, Comparator<T> comparator) {
        return CollectionUtil.mergeDuplicates(collection, comparator, null);
    }

    public static <T> List<T> mergeDuplicates(Collection<T> collection, Merger<T> merger) {
        return CollectionUtil.mergeDuplicates(collection, null, merger);
    }

    public static <T> List<T> mergeDuplicates(Collection<T> collection, Comparator<T> comparator, Merger<T> merger) {
        if (collection == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection) {
            int n;
            if (comparator == null) {
                n = arrayList.indexOf(t);
            } else {
                n = -1;
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    Object e = arrayList.get(i);
                    if (comparator.compare(t, e) != 0) continue;
                    n = i;
                    break;
                }
            }
            if (n < 0) {
                arrayList.add(t);
                continue;
            }
            if (merger == null) continue;
            Object e = arrayList.get(n);
            T t2 = merger.merge(e, t);
            arrayList.set(n, t2);
        }
        return arrayList;
    }

    public static <T> Set<T> union(Collection<T> collection, Collection<T> collection2) {
        if (collection == null || collection.size() == 0) {
            return CollectionUtil.toSet(collection2);
        }
        if (collection2 == null || collection2.size() == 0) {
            return CollectionUtil.toSet(collection);
        }
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        hashSet.addAll(collection2);
        return hashSet;
    }

    public static <T> Set<T> minus(Collection<T> collection, Collection<T> collection2) {
        if (collection == null || collection.size() == 0) {
            return Collections.emptySet();
        }
        if (collection2 == null || collection2.size() == 0) {
            return CollectionUtil.toSet(collection);
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : collection) {
            if (collection2.contains(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection == null || collection.size() == 0) {
            return Collections.emptySet();
        }
        if (collection instanceof Set) {
            return (Set)collection;
        }
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        return hashSet;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> void populateInverseMap(Map<K, V> map, Map<V, K> map2) {
        ValidationUtil.paramsNotNull(map, map2);
        if (!map2.isEmpty()) {
            throw new IllegalArgumentException("Inverse map must be empty.");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v = entry.getValue();
            K k = map2.put(v, entry.getKey());
            if (k == null) continue;
            throw new IllegalArgumentException("Found duplicate mapping for value: " + v);
        }
    }

    public static <K, V> void populateInverseMapForSets(Map<K, V> map, Map<V, Set<K>> map2) {
        ValidationUtil.paramsNotNull(map, map2);
        if (!map2.isEmpty()) {
            throw new IllegalArgumentException("Inverse map must be empty.");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v = entry.getValue();
            Set<K> set = map2.get(v);
            if (set == null) {
                set = new HashSet<K>();
                map2.put((Set<K>)v, (Set<V>)set);
            }
            set.add(entry.getKey());
        }
    }

    public static <K, V> Map<K, Set<V>> getUnmodifiableMapOfSets(Map<K, Set<V>> map) {
        ValidationUtil.paramsNotNull(map);
        for (Map.Entry<K, Set<Set<V>>> entry : map.entrySet()) {
            Set<V> set = entry.getValue();
            if (set == null) continue;
            entry.setValue(Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, List<V>> getUnmodifiableMapOfLists(Map<K, List<V>> map) {
        ValidationUtil.paramsNotNull(map);
        for (Map.Entry<K, List<List<V>>> entry : map.entrySet()) {
            List<V> list = entry.getValue();
            if (list == null) continue;
            entry.setValue(Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, Set<V>> mergeSets(Collection<Map<K, Set<V>>> collection) {
        ValidationUtil.paramsNotNull(collection);
        HashMap<K, HashSet<V>> hashMap = new HashMap<K, HashSet<V>>();
        for (Map<K, Set<V>> map : collection) {
            for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
                K k = entry.getKey();
                Set<V> set = entry.getValue();
                if (set == null || set.isEmpty()) continue;
                HashSet<V> hashSet = (HashSet<V>)hashMap.get(k);
                if (hashSet == null) {
                    hashSet = new HashSet<V>();
                    hashMap.put(k, hashSet);
                }
                hashSet.addAll(set);
            }
        }
        return hashMap;
    }
}

