/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.collection;

import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

public class DepthFirstTreeIterator<T>
implements TreeIterator<T> {
    private static final String INVALID_STATE_MSG = "The 'next' method has not yet been called, or the 'remove'/'set' method has already been called.";
    private final Tree<T> _tree;
    private Node<T> _currentNode;
    private final Stack<Node<T>> _fringe = new Stack();

    public DepthFirstTreeIterator(Tree<T> tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Invalid tree.");
        }
        this._tree = tree;
        Node<T> node = tree.getRoot();
        if (node != null) {
            this._fringe.push(tree.getRoot());
        }
    }

    @Override
    public boolean hasNext() {
        return !this._fringe.isEmpty();
    }

    @Override
    public Node<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._currentNode = this._fringe.pop();
        this.registerChildrenForVisiting(this._currentNode);
        return this._currentNode;
    }

    @Override
    public void remove() {
        if (this._currentNode == null) {
            throw new IllegalStateException(INVALID_STATE_MSG);
        }
        this.unregisterChildrenFromVisiting(this._currentNode);
        Node<T> node = this._currentNode.getParent();
        this.removeNode(node, this._currentNode);
        this._currentNode = null;
    }

    @Override
    public void add(Node<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("Invalid tree node.");
        }
        if (this._currentNode == null) {
            throw new IllegalStateException(INVALID_STATE_MSG);
        }
        this.addNode(this._currentNode, node);
        this._fringe.push(node);
        this._currentNode = null;
    }

    @Override
    public void set(Node<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("Invalid node.");
        }
        if (this._currentNode == null) {
            throw new IllegalStateException(INVALID_STATE_MSG);
        }
        this.unregisterChildrenFromVisiting(this._currentNode);
        Node<T> node2 = this._currentNode.getParent();
        this.replaceNode(node2, this._currentNode, node);
        this.registerChildrenForVisiting(node);
        this._currentNode = node;
    }

    private void removeNode(Node<T> node, Node<T> node2) {
        assert (node2 != null);
        if (node != null) {
            node.removeChild(node2);
        } else {
            this._tree.setRoot(null);
        }
    }

    private void addNode(Node<T> node, Node<T> node2) {
        assert (node2 != null);
        if (node != null) {
            node.appendChild(node2);
        } else {
            this._tree.setRoot(node2);
        }
    }

    private void replaceNode(Node<T> node, Node<T> node2, Node<T> node3) {
        assert (node2 != null && node3 != null);
        if (node != null) {
            int n = node.getChildren().indexOf(node2);
            if (n >= 0) {
                node.setChild(n, node3);
            } else {
                node.appendChild(node3);
            }
        } else {
            this._tree.setRoot(node3);
        }
    }

    private void unregisterChildrenFromVisiting(Node<T> node) {
        assert (node != null);
        List<Node<T>> list = node.getChildren();
        this._fringe.removeAll(list);
    }

    private void registerChildrenForVisiting(Node<T> node) {
        assert (node != null);
        List<Node<T>> list = node.getChildren();
        for (Node node2 : list) {
            this._fringe.push(node2);
        }
    }
}

