/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.common;

import com.vmware.vise.util.os.WindowsShellFolderUtil;
import java.io.File;
import org.apache.commons.lang.SystemUtils;

public final class Environment {
    private static final String CLIENT_APP_DATA_FOLDER;
    private static final String SYSPROP_COMPONENT_NAME = "ui.component.name";
    private static final String DEFAULT_COMPONENT_NAME = "vsphere-client";

    public static String fileSeparator() {
        return File.separator;
    }

    public static String clientAppDataFolder() {
        return CLIENT_APP_DATA_FOLDER;
    }

    public static String allUsersAppDataFolder() {
        return SystemUtils.IS_OS_WINDOWS ? WindowsShellFolderUtil.getCommonAppDataFolder() : "/var/lib";
    }

    static {
        String string = System.getenv("VMWARE_CFG_DIR");
        String string2 = System.getProperty(SYSPROP_COMPONENT_NAME, DEFAULT_COMPONENT_NAME);
        if (string == null || string.equals("")) {
            throw new RuntimeException("The VMWARE_CFG_DIR environmental variable is unset.");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("The VMWARE_CFG_DIR environmental variable is set to a non-existent path.");
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("The VMWARE_CFG_DIR environmental variable is set to a non-directory path.");
        }
        CLIENT_APP_DATA_FOLDER = string != null ? string + Environment.fileSeparator() + string2 : (SystemUtils.IS_OS_WINDOWS ? Environment.allUsersAppDataFolder() + "\\VMware\\vSphere Web Client" : Environment.allUsersAppDataFolder() + "/vmware/vsphere-client");
    }
}

