/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.ValidationUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;

public final class BlockingUtil {
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        ValidationUtil.paramsNotNull(countDownLatch);
        boolean bl = false;
        while (true) {
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean await(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull(countDownLatch);
        try {
            boolean bl = countDownLatch.await(l, timeUnit);
            return bl;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean await(Condition condition, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull(condition);
        try {
            boolean bl = condition.await(l, timeUnit);
            return bl;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        ValidationUtil.paramsNotNull(future);
        boolean bl = false;
        while (true) {
            try {
                V v;
                V v2 = v = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V get(Future<V> future, long l, TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        ValidationUtil.paramsNotNull(future);
        try {
            V v = future.get(l, timeUnit);
            return v;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleepUntilTimeElapses(long l) throws InterruptedException {
        if (l < 1L) {
            throw new IllegalArgumentException("sleepTime must be at least 1 ms.");
        }
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (l3 > 0L) {
            Thread.sleep(l3);
            l3 = l2 - System.currentTimeMillis();
        }
    }
}

