/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdleThreadsAwareThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Log _logger = LogFactory.getLog(IdleThreadsAwareThreadPoolExecutor.class);
    private final String _poolName;
    private final long _submissionTimeoutIfThereAreIdleThreads;
    private final TimeUnit _submissionUnitIfThereAreIdleThreads;
    private final Set<TaskResubmissionListener> _listeners = new CopyOnWriteArraySet<TaskResubmissionListener>();

    public IdleThreadsAwareThreadPoolExecutor(String string, int n, int n2, long l, TimeUnit timeUnit, int n3, ThreadFactory threadFactory, long l2, TimeUnit timeUnit2) {
        this(string, n, n2, l, timeUnit, new LinkedBlockingQueue<Runnable>(n3), threadFactory, l2, timeUnit2);
    }

    public IdleThreadsAwareThreadPoolExecutor(String string, int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, long l2, TimeUnit timeUnit2) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
        if (StringUtil.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("The poolName shouldn't be null or empty");
        }
        this._poolName = string;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("submissionTimeoutIfThereAreIdleThreads should be greater than zero");
        }
        if (timeUnit2 == null) {
            throw new IllegalArgumentException("submissionUnitIfThereAreIdleThreads shouldn't be null");
        }
        this._submissionTimeoutIfThereAreIdleThreads = l2;
        this._submissionUnitIfThereAreIdleThreads = timeUnit2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        block24: {
            try {
                super.execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Object object;
                block23: {
                    int n;
                    int n2 = this.getActiveCount();
                    int n3 = this.getPoolSize();
                    int n4 = n3 - n2;
                    BlockingQueue<Runnable> blockingQueue = super.getQueue();
                    int n5 = blockingQueue.remainingCapacity();
                    if (n4 <= 0 && n5 == 0) {
                        throw new RejectedExecutionException(rejectedExecutionException.getMessage(), rejectedExecutionException);
                    }
                    if (_logger.isDebugEnabled()) {
                        int n6 = blockingQueue.size();
                        n = this.getCorePoolSize();
                        int n7 = this.getMaximumPoolSize();
                        _logger.debug((Object)("Thread pool '" + this._poolName + "' has rejected a task " + "even though there were idle threads in the pool " + "at the time when the task was submitted. " + "For a short time, we will be trying to submit the task " + "hoping that the idle threads will pull tasks out of the " + "queue and will free up some space for our task. " + "*Current* pool statistics: queueSize=" + n6 + ", numThreadsInPool=" + n3 + ", numBusyThreads=" + n2 + ", numIdleThreads=" + n4 + ", corePoolSize=" + n + ", maxPoolSize=" + n7));
                    }
                    for (TaskResubmissionListener taskResubmissionListener : this._listeners) {
                        try {
                            taskResubmissionListener.beforeTaskResubmission(runnable);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)(taskResubmissionListener + " crashed"), (Throwable)exception);
                        }
                    }
                    object = null;
                    try {
                        n = blockingQueue.offer(runnable, this._submissionTimeoutIfThereAreIdleThreads, this._submissionUnitIfThereAreIdleThreads) ? 1 : 0;
                        if (n != 0) break block23;
                        object = new RejectedExecutionException(rejectedExecutionException.getMessage(), rejectedExecutionException);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        object = new RejectedExecutionException(rejectedExecutionException.getMessage(), rejectedExecutionException);
                    }
                    catch (RuntimeException runtimeException) {
                        object = runtimeException;
                    }
                    finally {
                        for (TaskResubmissionListener taskResubmissionListener : this._listeners) {
                            try {
                                taskResubmissionListener.afterTaskResubmission(runnable, (RuntimeException)object);
                            }
                            catch (Exception exception) {
                                _logger.error((Object)(taskResubmissionListener + " crashed"), (Throwable)exception);
                            }
                        }
                    }
                }
                if (object == null) break block24;
                throw object;
            }
        }
    }

    public boolean addTaskResubmissionListener(TaskResubmissionListener taskResubmissionListener) {
        Preconditions.checkNotNull((Object)taskResubmissionListener);
        boolean bl = this._listeners.add(taskResubmissionListener);
        return bl;
    }

    public boolean removeTaskResubmissionListener(TaskResubmissionListener taskResubmissionListener) {
        Preconditions.checkNotNull((Object)taskResubmissionListener);
        boolean bl = this._listeners.remove(taskResubmissionListener);
        return bl;
    }

    public static interface TaskResubmissionListener {
        public void beforeTaskResubmission(Runnable var1);

        public void afterTaskResubmission(Runnable var1, RuntimeException var2);
    }
}

