/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.ValidationUtil;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LoggingRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static final Log _logger = LogFactory.getLog(LoggingRejectedExecutionHandler.class);
    private final AtomicLong _rejectedTaskCounter = new AtomicLong(0L);
    private final RejectedExecutionHandler _handler;
    private final String _poolName;

    public LoggingRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler, String string) {
        ValidationUtil.paramsNotNull(rejectedExecutionHandler, string);
        this._handler = rejectedExecutionHandler;
        this._poolName = string;
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        long l = this._rejectedTaskCounter.incrementAndGet();
        _logger.warn((Object)("Rejected task from pool: " + this._poolName + " rejection count: " + l));
        this._handler.rejectedExecution(runnable, threadPoolExecutor);
    }
}

