/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.util.concurrent.SettableFuture;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.AtomicUtil;
import com.vmware.vise.util.concurrent.ConcurrencyUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ExpirationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueuingCachedThreadPool
implements ExecutorService {
    private static final Log _logger = LogFactory.getLog(QueuingCachedThreadPool.class);
    private static final int STATS_INTERVAL = 500;
    private static final double MILLIS_PER_SECOND = 1000.0;
    private final ThreadPoolExecutor _executor;
    private final ExecutionManager _executionManager;
    private final AtomicLong _taskGroupIdGenerator = new AtomicLong(0L);
    private final AtomicLong _tasksSubmitted = new AtomicLong(0L);
    private final AtomicLong _tasksRunByWorkPool = new AtomicLong(0L);
    private final AtomicLong _tasksRunByCaller = new AtomicLong(0L);
    private final AtomicLong _tasksExpired = new AtomicLong(0L);
    private final AtomicLong _taskWaitTimeInMicroSecs = new AtomicLong(0L);
    private final AtomicInteger _workerThreadCounter = new AtomicInteger(0);
    private final AtomicInteger _largestObservedQueueSize = new AtomicInteger(0);
    private final AtomicInteger _largestNumberOfWorkerThreads = new AtomicInteger(0);
    private final long _taskExpirationNanos;
    private final TaskExpirationPolicy _taskExpirationPolicy;
    private final String _label;
    private final boolean _loggingEnabled;

    public QueuingCachedThreadPool(int n, ThreadFactory threadFactory, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2, TaskExpirationPolicy taskExpirationPolicy, boolean bl) {
        ValidationUtil.paramsNotNull(threadFactory);
        this._executionManager = new ExecutionManager(n);
        this._taskExpirationNanos = l >= 0L ? TimeUnit.NANOSECONDS.convert(l, timeUnit) : Long.MAX_VALUE;
        this._executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, l2, timeUnit2, new SynchronousQueue<Runnable>(), threadFactory);
        this._taskExpirationPolicy = taskExpirationPolicy;
        this._executor.execute(ExecutorUtil.EMPTY_RUNNABLE);
        this._label = threadFactory.toString();
        this._loggingEnabled = bl;
    }

    @Override
    public void shutdown() {
        this._executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        arrayList.addAll(this._executor.shutdownNow());
        this._executionManager.drainQueue(arrayList);
        return arrayList;
    }

    @Override
    public boolean isShutdown() {
        return this._executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        boolean bl = this._executor.isTerminated();
        return bl;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        ValidationUtil.paramsNotNull(new Object[]{timeUnit});
        boolean bl = this._executor.awaitTermination(l, timeUnit);
        return bl;
    }

    @Override
    public void execute(Runnable runnable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        this.innerSubmit(runnable, null, String.valueOf(l2), l2, l);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<T> future = this.innerSubmit(callable, String.valueOf(l2), l2, l);
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<T> future = this.innerSubmit(runnable, t, String.valueOf(l2), l2, l);
        return future;
    }

    public Future<Void> submit(Runnable runnable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<Object> future = this.innerSubmit(runnable, null, String.valueOf(l2), l2, l);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        Long l2 = this._taskGroupIdGenerator.incrementAndGet();
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        int n = 1;
        for (Callable<T> object : collection) {
            Future<T> future = this.innerSubmit(object, this.getTaskLabel(l2, n), l2, l);
            ++n;
            arrayList.add(future);
        }
        try {
            for (Future future : arrayList) {
                try {
                    if (future.isDone()) continue;
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l3 = l2 + TimeUnit.NANOSECONDS.convert(l, timeUnit);
        Long l4 = this._taskGroupIdGenerator.incrementAndGet();
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        int n = 1;
        for (Callable<T> object : collection) {
            Future<T> future = this.innerSubmit(object, this.getTaskLabel(l4, n), l4, l2);
            ++n;
            arrayList.add(future);
        }
        try {
            for (Future future : arrayList) {
                long l5 = l3 - System.nanoTime();
                try {
                    if (future.isDone()) continue;
                    future.get(l5, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException timeoutException) {
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        return arrayList;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        long l = System.nanoTime();
        T t = null;
        try {
            t = this.doInvokeAny(collection, null, l);
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(timeoutException);
        }
        return t;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = System.nanoTime();
        Long l3 = l2 + TimeUnit.NANOSECONDS.convert(l, timeUnit);
        T t = this.doInvokeAny(collection, l3, l2);
        return t;
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> collection, Long l, long l2) throws InterruptedException, ExecutionException, TimeoutException {
        InvokeAnyResult invokeAnyResult;
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Long l3 = this._taskGroupIdGenerator.incrementAndGet();
        int n = 1;
        int n2 = 0;
        Exception exception = null;
        LinkedBlockingQueue<InvokeAnyResult<T>> linkedBlockingQueue = new LinkedBlockingQueue<InvokeAnyResult<T>>();
        LinkedList<Future<T>> linkedList = new LinkedList<Future<T>>();
        Iterator<Callable<T>> iterator = collection.iterator();
        Callable<T> callable = iterator.next();
        Future<T> future = this.innerSubmit(this.getNotifyingCallable(callable, linkedBlockingQueue), this.getTaskLabel(l3, n), l3, l2);
        linkedList.add(future);
        ++n;
        while (iterator.hasNext()) {
            invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll();
            while (invokeAnyResult != null) {
                if (invokeAnyResult.exception == null) {
                    this.cancelUnfinished(linkedList);
                    return invokeAnyResult.computationResult;
                }
                exception = invokeAnyResult.exception;
                ++n2;
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll();
            }
            callable = iterator.next();
            future = this.innerSubmit(this.getNotifyingCallable(callable, linkedBlockingQueue), this.getTaskLabel(l3, n), l3, l2);
            ++n;
            linkedList.add(future);
        }
        while (n2 < collection.size()) {
            if (l == null) {
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.take();
            } else {
                long l4 = l - System.nanoTime();
                if (l4 <= 0L) {
                    this.cancelUnfinished(linkedList);
                    throw new TimeoutException();
                }
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll(l4, TimeUnit.NANOSECONDS);
            }
            if (invokeAnyResult != null && invokeAnyResult.exception == null) {
                this.cancelUnfinished(linkedList);
                return invokeAnyResult.computationResult;
            }
            if (invokeAnyResult != null) {
                exception = invokeAnyResult.exception;
            }
            ++n2;
        }
        throw new ExecutionException(exception);
    }

    private <T> void cancelUnfinished(List<Future<T>> list) {
        for (Future<T> future : list) {
            future.cancel(true);
        }
    }

    private <T> Callable<T> getNotifyingCallable(final Callable<T> callable, final BlockingQueue<InvokeAnyResult<T>> blockingQueue) {
        Callable callable2 = new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object t = null;
                Exception exception = null;
                try {
                    Object t2 = t = (Object)callable.call();
                    return t2;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    throw exception2;
                }
                finally {
                    InvokeAnyResult<Object> invokeAnyResult = new InvokeAnyResult<Object>(t, exception);
                    blockingQueue.add(invokeAnyResult);
                }
            }
        };
        return callable2;
    }

    private <T> Future<T> innerSubmit(Callable<T> callable, String string, long l, long l2) {
        this.logSubmittedTask(string);
        long l3 = l2 + this._taskExpirationNanos;
        ExpiringTask<T> expiringTask = new ExpiringTask<T>(callable, string, l, l2, l3);
        this._executionManager.processNewTask(expiringTask);
        if (l % 500L == 0L) {
            this.printStats();
        }
        return expiringTask;
    }

    private <T> Future<T> innerSubmit(final Runnable runnable, final T t, String string, long l, long l2) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() {
                runnable.run();
                return t;
            }
        };
        Future<T> future = this.innerSubmit(callable, string, l, l2);
        return future;
    }

    private String getTaskLabel(long l, int n) {
        if (!this._loggingEnabled) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        stringBuilder.append('-');
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private void logRanTask(ExpiringTask<?> expiringTask) {
        long l = TimeUnit.MICROSECONDS.convert(System.nanoTime() - expiringTask.getSubmissionTime(), TimeUnit.NANOSECONDS);
        this._taskWaitTimeInMicroSecs.addAndGet(l);
        this._tasksRunByWorkPool.incrementAndGet();
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" ran task ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" after a wait time of (micro-sec): ");
        stringBuilder.append(l);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logPoolManagementTime(ExpiringTask<?> expiringTask, long l) {
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        long l2 = TimeUnit.MICROSECONDS.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" assigned task ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" after time of (micro-sec): ");
        stringBuilder.append(l2);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logExpiredTask(ExpiringTask<?> expiringTask) {
        this._tasksExpired.incrementAndGet();
        if (!this._loggingEnabled) {
            return;
        }
        long l = System.nanoTime();
        long l2 = l - expiringTask.getSubmissionTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" task# ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" expired after ");
        stringBuilder.append((double)TimeUnit.NANOSECONDS.toMillis(l2) / 1000.0);
        stringBuilder.append(" sec.");
        _logger.warn((Object)stringBuilder.toString());
    }

    private void logSubmittedTask(String string) {
        this._tasksSubmitted.incrementAndGet();
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" accepting task# ");
        stringBuilder.append(string);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logRanExpiredTaskInCallerThread(ExpiringTask<?> expiringTask) {
        this._tasksRunByCaller.incrementAndGet();
        if (!this._loggingEnabled) {
            return;
        }
        long l = System.nanoTime();
        long l2 = l - expiringTask.getSubmissionTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" ran task# ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" in calling thread after ");
        stringBuilder.append((double)TimeUnit.NANOSECONDS.toMillis(l2) / 1000.0);
        stringBuilder.append(" sec.");
        _logger.info((Object)stringBuilder.toString());
    }

    private void logQueueHitNewMax(int n) {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" hit new max size: ");
        stringBuilder.append(n);
        _logger.info((Object)stringBuilder.toString());
    }

    private void logWorkersHitNewMax(int n) {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" workers hit new max size: ");
        stringBuilder.append(n);
        _logger.info((Object)stringBuilder.toString());
    }

    private void printStats() {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("stats for pool : ");
        stringBuilder.append(this._label);
        stringBuilder.append("\nTasks submitted: ");
        stringBuilder.append(this._tasksSubmitted.get());
        stringBuilder.append("\nTasks run by workers: ");
        stringBuilder.append(this._tasksRunByWorkPool.get());
        stringBuilder.append("\nTasks expired: ");
        stringBuilder.append(this._tasksExpired.get());
        stringBuilder.append("\nAverage wait time before running (micro-sec): ");
        long l = this._tasksRunByWorkPool.get();
        if (l > 0L) {
            long l2 = this._taskWaitTimeInMicroSecs.get() / l;
            stringBuilder.append(l2);
        }
        stringBuilder.append("\nCaller-run tasks: ");
        stringBuilder.append(this._tasksRunByCaller.get());
        stringBuilder.append("\nMax queue-size reached: ");
        stringBuilder.append(this._largestObservedQueueSize.get());
        stringBuilder.append("\nLargest work-queue size: ");
        stringBuilder.append(this._largestNumberOfWorkerThreads.get());
        _logger.info((Object)stringBuilder.toString());
    }

    private static void logIfWaitingThresholdIsExceeded(ExpiringTask<?> expiringTask) {
        long l = System.nanoTime() - expiringTask.getSubmissionTime();
        if (l > ConcurrencyUtil.TASK_WAIT_TIME_THRESHOLD_IN_NANOS) {
            _logger.warn((Object)("A task waited too long to be executed: " + TimeUnit.NANOSECONDS.toMillis(l) + " ms, task# " + expiringTask.getLabel() + ", " + expiringTask.toString()));
        }
    }

    public String toString() {
        return this._executor.getThreadFactory().toString();
    }

    public static enum TaskExpirationPolicy {
        CALLER_RUNS,
        CANCEL;

    }

    private class ExpiringTask<T>
    extends FutureTask<T>
    implements Comparable<ExpiringTask<T>> {
        private final SettableFuture<Boolean> _taskStarted;
        private final AtomicBoolean _expirationHandled;
        private final String _label;
        private final Long _groupId;
        private final long _submissionTime;
        private final long _expirationTime;
        private final Callable<T> _actualTask;

        ExpiringTask(Callable<T> callable, String string, long l, long l2, long l3) {
            super(callable);
            this._taskStarted = SettableFuture.create();
            this._expirationHandled = new AtomicBoolean(false);
            this._label = string;
            this._groupId = l;
            this._submissionTime = l2;
            this._expirationTime = l3;
            this._actualTask = callable;
        }

        String getLabel() {
            return this._label;
        }

        long getSubmissionTime() {
            return this._submissionTime;
        }

        boolean isPastExirationTime() {
            return System.nanoTime() >= this._expirationTime;
        }

        boolean signalWaiters(boolean bl) {
            boolean bl2 = this._taskStarted.set((Object)bl);
            if (bl2 && !bl) {
                QueuingCachedThreadPool.this.logExpiredTask(this);
            }
            return bl2;
        }

        private void handleIfExpired() throws InterruptedException {
            try {
                boolean bl;
                if (this._taskStarted.isDone()) {
                    boolean bl2 = (Boolean)this._taskStarted.get();
                    if (!bl2) {
                        this.handleExpiredTaskIfNotHandledYet();
                    }
                    return;
                }
                long l = this._expirationTime - System.nanoTime();
                try {
                    bl = (Boolean)this._taskStarted.get(l, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException timeoutException) {
                    QueuingCachedThreadPool.this._executionManager.removeTaskFromQueue(this);
                    boolean bl3 = this.signalWaiters(false);
                    bl = bl3 ? false : (Boolean)this._taskStarted.get();
                }
                if (!bl) {
                    this.handleExpiredTaskIfNotHandledYet();
                }
            }
            catch (ExecutionException executionException) {
                throw new IllegalStateException("Cannot happen with SettableFuture.");
            }
        }

        private boolean waitUntilRunOrExpired(long l) throws InterruptedException {
            try {
                if (this._taskStarted.isDone()) {
                    boolean bl = (Boolean)this._taskStarted.get();
                    return !bl;
                }
                long l2 = this._expirationTime - System.nanoTime();
                if (l < l2) {
                    l2 = l;
                }
                try {
                    Boolean bl = (Boolean)this._taskStarted.get(l2, TimeUnit.NANOSECONDS);
                    if (bl.booleanValue()) {
                        return false;
                    }
                    boolean bl2 = System.nanoTime() >= this._expirationTime;
                    return bl2;
                }
                catch (TimeoutException timeoutException) {
                    boolean bl = System.nanoTime() >= this._expirationTime;
                    return bl;
                }
            }
            catch (ExecutionException executionException) {
                throw new IllegalStateException("cannot happen.");
            }
        }

        private void handleExpiredTaskIfNotHandledYet() {
            if (QueuingCachedThreadPool.this._taskExpirationPolicy == TaskExpirationPolicy.CALLER_RUNS) {
                boolean bl = this._expirationHandled.getAndSet(true);
                if (!bl) {
                    this.run();
                    QueuingCachedThreadPool.this.logRanExpiredTaskInCallerThread(this);
                }
            } else if (QueuingCachedThreadPool.this._taskExpirationPolicy == TaskExpirationPolicy.CANCEL) {
                boolean bl = this._expirationHandled.getAndSet(true);
                if (!bl) {
                    super.cancel(true);
                }
                throw new ExpirationException();
            }
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            this.handleIfExpired();
            Object v = super.get();
            return (T)v;
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            long l2 = System.nanoTime();
            long l3 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
            boolean bl = this.waitUntilRunOrExpired(l3);
            long l4 = System.nanoTime() - l2;
            if (bl) {
                QueuingCachedThreadPool.this._executionManager.removeTaskFromQueue(this);
                boolean bl2 = this.signalWaiters(false);
                if (bl2 || !((Boolean)this._taskStarted.get()).booleanValue()) {
                    this.handleExpiredTaskIfNotHandledYet();
                }
            }
            Object v = super.get(l3 - l4, TimeUnit.NANOSECONDS);
            return (T)v;
        }

        @Override
        public int compareTo(ExpiringTask<T> expiringTask) {
            if (expiringTask == null) {
                throw new NullPointerException("Null tasks should not be queued.");
            }
            return this._groupId.compareTo(expiringTask._groupId);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this._actualTask.toString();
        }
    }

    private class QueueProcessor
    implements Runnable {
        private ExpiringTask<?> _task;

        QueueProcessor(ExpiringTask<?> expiringTask) {
            this._task = expiringTask;
            if (QueuingCachedThreadPool.this._loggingEnabled) {
                int n = QueuingCachedThreadPool.this._workerThreadCounter.incrementAndGet();
                boolean bl = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestNumberOfWorkerThreads, n);
                if (bl) {
                    QueuingCachedThreadPool.this.logWorkersHitNewMax(n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueuingCachedThreadPool.this.logRanTask(this._task);
            ExpiringTask<?> expiringTask = this._task;
            while (expiringTask != null) {
                try {
                    if (!expiringTask.isPastExirationTime()) {
                        boolean bl = expiringTask.signalWaiters(true);
                        if (bl) {
                            QueuingCachedThreadPool.logIfWaitingThresholdIsExceeded(expiringTask);
                            expiringTask.run();
                            continue;
                        }
                        _logger.info((Object)("A task's state was set by some other thread: " + expiringTask + ".  That other thread will handle the task."));
                        continue;
                    }
                    expiringTask.signalWaiters(false);
                }
                finally {
                    expiringTask = QueuingCachedThreadPool.this._executionManager.getNextTaskFromQueueOrRetireWorker();
                    if (!QueuingCachedThreadPool.this._loggingEnabled || expiringTask != null) continue;
                    QueuingCachedThreadPool.this._workerThreadCounter.decrementAndGet();
                }
            }
        }
    }

    private class ExecutionManager {
        private final int _maxThreads;
        private final Lock _lock = new ReentrantLock();
        @GuardedBy(value="_lock")
        private int _workerThreads = 0;
        @GuardedBy(value="_lock")
        private final PriorityQueue<ExpiringTask<?>> _queue = new PriorityQueue();

        ExecutionManager(int n) {
            this._maxThreads = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processNewTask(ExpiringTask<?> expiringTask) {
            boolean bl;
            int n;
            long l;
            LinkedList linkedList;
            ArrayList arrayList;
            block16: {
                boolean bl2;
                arrayList = new ArrayList(1);
                linkedList = new LinkedList();
                l = 0L;
                n = 0;
                if (QueuingCachedThreadPool.this._loggingEnabled) {
                    l = System.nanoTime();
                }
                this._lock.lock();
                if (this._workerThreads >= this._maxThreads || this._queue.size() != 0) break block16;
                ++this._workerThreads;
                arrayList.add(expiringTask);
                this._lock.unlock();
                QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
                for (ExpiringTask expiringTask2 : arrayList) {
                    QueuingCachedThreadPool.this._executor.submit(new QueueProcessor(expiringTask2));
                }
                for (ExpiringTask expiringTask2 : linkedList) {
                    expiringTask2.signalWaiters(false);
                }
                if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl2 = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                    QueuingCachedThreadPool.this.logQueueHitNewMax(n);
                }
                return;
            }
            try {
                this.removeExpiredTasksInternal(linkedList);
                while (this._workerThreads < this._maxThreads && !this._queue.isEmpty()) {
                    arrayList.add(this._queue.poll());
                    ++this._workerThreads;
                }
                if (this._workerThreads < this._maxThreads) {
                    arrayList.add(expiringTask);
                    ++this._workerThreads;
                } else {
                    this._queue.add(expiringTask);
                }
                n = this._queue.size();
                this._lock.unlock();
            }
            catch (Throwable throwable) {
                boolean bl3;
                this._lock.unlock();
                QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
                for (ExpiringTask expiringTask3 : arrayList) {
                    QueuingCachedThreadPool.this._executor.submit(new QueueProcessor(expiringTask3));
                }
                for (ExpiringTask expiringTask3 : linkedList) {
                    expiringTask3.signalWaiters(false);
                }
                if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl3 = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                    QueuingCachedThreadPool.this.logQueueHitNewMax(n);
                }
                throw throwable;
            }
            QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
            for (ExpiringTask expiringTask4 : arrayList) {
                QueuingCachedThreadPool.this._executor.submit(new QueueProcessor(expiringTask4));
            }
            for (ExpiringTask expiringTask5 : linkedList) {
                expiringTask5.signalWaiters(false);
            }
            if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                QueuingCachedThreadPool.this.logQueueHitNewMax(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExpiringTask<?> getNextTaskFromQueueOrRetireWorker() {
            this._lock.lock();
            try {
                ExpiringTask<?> expiringTask = this._queue.poll();
                if (expiringTask == null) {
                    --this._workerThreads;
                }
                ExpiringTask<?> expiringTask2 = expiringTask;
                return expiringTask2;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainQueue(Collection<Runnable> collection) {
            this._lock.lock();
            try {
                while (!this._queue.isEmpty()) {
                    collection.add((Runnable)this._queue.remove());
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeTaskFromQueue(ExpiringTask<?> expiringTask) {
            boolean bl = false;
            this._lock.lock();
            try {
                bl = this._queue.remove(expiringTask);
            }
            finally {
                this._lock.unlock();
            }
            return bl;
        }

        @GuardedBy(value="_lock")
        private void removeExpiredTasksInternal(Collection<ExpiringTask<?>> collection) {
            for (ExpiringTask<?> expiringTask : this._queue) {
                if (!expiringTask.isPastExirationTime()) continue;
                collection.add(expiringTask);
            }
            this._queue.removeAll(collection);
        }
    }

    private static class InvokeAnyResult<T> {
        final T computationResult;
        final Exception exception;

        InvokeAnyResult(T t, Exception exception) {
            this.computationResult = t;
            this.exception = exception;
        }
    }
}

