/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.debug;

import com.vmware.vise.util.concurrent.ThreadUtil;
import com.vmware.vise.util.debug.thread.ThreadUsageDumper;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemUsageMonitor {
    private static final Log _logger = LogFactory.getLog(SystemUsageMonitor.class);
    private static String USAGE_FORMAT = "\n Heap     : %1$s\n non-Heap : %2$s\n No of loaded classes: %3$d";
    private static String THREAD_USAGE_FORMAT = "\n Live Thread Count(w/o the live daemon threads): %1$d\n Peak Thread Count: %2$d\n Daemon Thread Count: %3$d\n\n Tomcat Request-Processing Threads Count: %4$d\n Blocked threads: %5$d\n Waiting threads: %6$d\n Threads blocked in Data Service: %7$d\n Threads waiting in Data Service: %8$d\n Threads blocked in Logback: %9$d\n Threads waiting in Logback: %10$d";
    private long _trackingPeriod;
    private Timer _timer;
    private ThreadUsageDumper _threadDumper;

    public SystemUsageMonitor(long l) {
        if (!_logger.isInfoEnabled()) {
            return;
        }
        this._trackingPeriod = l;
        this._threadDumper = new ThreadUsageDumper();
        this.initTimer();
    }

    private void initTimer() {
        this._timer = new Timer(true);
        this.writeSystemInfo();
        this._timer.schedule((TimerTask)new UsageStatsLoggerTask(), 0L, this._trackingPeriod);
    }

    private void writeSystemInfo() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            StringBuilder stringBuilder = new StringBuilder("System info :");
            stringBuilder.append("\n OS - ");
            stringBuilder.append(operatingSystemMXBean.getName());
            stringBuilder.append("\n Arch - ");
            stringBuilder.append(operatingSystemMXBean.getArch());
            stringBuilder.append("\n Java Version - ");
            stringBuilder.append(System.getProperties().get("java.version"));
            _logger.info((Object)stringBuilder.toString());
        }
        catch (SecurityException securityException) {
            _logger.error((Object)"Exception in writing basic system info.", (Throwable)securityException);
        }
    }

    static ThreadStatistics gatherThreadsStatistics(Thread[] threadArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ThreadInfo[] threadInfoArray = null;
        String string = null;
        block0: for (Thread thread : threadArray) {
            StackTraceElement[] stackTraceElementArray;
            Thread.State state = thread.getState();
            String string2 = thread.getName();
            if (string2.startsWith("http-bio-") && string2.indexOf("-exec-", 10) > 0) {
                ++n;
            }
            if (state == Thread.State.BLOCKED) {
                ++n2;
            } else {
                if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING) continue;
                ++n3;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray = thread.getStackTrace()) {
                String string3 = stackTraceElement.getClassName();
                if (string3.contains("DataServiceImpl")) {
                    if (state == Thread.State.BLOCKED) {
                        ++n4;
                        continue block0;
                    }
                    ++n5;
                    continue block0;
                }
                if (!string3.contains("logback")) continue;
                if (state == Thread.State.BLOCKED) {
                    ++n6;
                    continue block0;
                }
                ++n7;
                continue block0;
            }
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = null;
        long l = -1L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = _logger.isDebugEnabled();
        if (bl3) {
            long l2 = System.nanoTime();
            lArray = threadMXBean.findDeadlockedThreads();
            l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            bl = n6 > 7;
            boolean bl4 = bl2 = n2 > 150;
        }
        if (lArray != null || bl || bl2) {
            threadInfoArray = threadMXBean.dumpAllThreads(true, true);
            if (lArray != null) {
                string = "Deadlocked threads detected";
            } else if (bl) {
                string = "Too many blocked loggers";
            } else if (bl2) {
                string = "More than " + n2 + " blocked threads";
            }
        }
        return new ThreadStatistics(n, n2, n3, n4, n5, n6, n7, lArray, l, threadInfoArray, string);
    }

    static class ThreadStatistics {
        private final int _tomcatRequestProcessingThreadsCount;
        private final int _blockedThreadsCount;
        private final int _waitingThreadsCount;
        private final int _blockedDataServiceThreadsCount;
        private final int _waitingDataServiceThreadsCount;
        private final int _blockedLogbackThreadsCount;
        private final int _waitingLogbackThreadsCount;
        private final long[] _deadlockedThreadIds;
        private final long _deadlockDetectionDurationInMillis;
        private final ThreadInfo[] _threadInfos;
        private final String _reasonForThreadInfos;

        public ThreadStatistics(int n, int n2, int n3, int n4, int n5, int n6, int n7, @Nullable long[] lArray, long l, @Nullable ThreadInfo[] threadInfoArray, @Nullable String string) {
            this._tomcatRequestProcessingThreadsCount = n;
            this._blockedThreadsCount = n2;
            this._waitingThreadsCount = n3;
            this._blockedDataServiceThreadsCount = n4;
            this._waitingDataServiceThreadsCount = n5;
            this._blockedLogbackThreadsCount = n6;
            this._waitingLogbackThreadsCount = n7;
            this._deadlockedThreadIds = lArray;
            this._deadlockDetectionDurationInMillis = l;
            this._threadInfos = threadInfoArray;
            this._reasonForThreadInfos = string;
        }

        public int getTomcatRequestProcessingThreadsCount() {
            return this._tomcatRequestProcessingThreadsCount;
        }

        public int getBlockedDataServiceThreadsCount() {
            return this._blockedDataServiceThreadsCount;
        }
    }

    private class UsageStatsLoggerTask
    extends TimerTask {
        private UsageStatsLoggerTask() {
        }

        @Override
        public void run() {
            try {
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                if (memoryMXBean == null) {
                    return;
                }
                MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
                MemoryUsage memoryUsage2 = memoryMXBean.getNonHeapMemoryUsage();
                String string = String.format(USAGE_FORMAT, memoryUsage.toString(), memoryUsage2.toString(), ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                if (threadMXBean == null) {
                    return;
                }
                int n = threadMXBean.getDaemonThreadCount();
                int n2 = threadMXBean.getPeakThreadCount();
                int n3 = threadMXBean.getThreadCount();
                int n4 = n3 - n;
                Thread[] threadArray = ThreadUtil.getAllThreads();
                ThreadStatistics threadStatistics = SystemUsageMonitor.gatherThreadsStatistics(threadArray);
                String string2 = String.format(THREAD_USAGE_FORMAT, n4, n2, n, threadStatistics._tomcatRequestProcessingThreadsCount, threadStatistics._blockedThreadsCount, threadStatistics._waitingThreadsCount, threadStatistics._blockedDataServiceThreadsCount, threadStatistics._waitingDataServiceThreadsCount, threadStatistics._blockedLogbackThreadsCount, threadStatistics._waitingLogbackThreadsCount);
                StringBuilder stringBuilder = new StringBuilder(1000);
                stringBuilder.append(String.format("Summary: heap = %1$.2f MB, threads = %2$d", (double)memoryUsage.getUsed() / 1048576.0, n3));
                stringBuilder.append(string).append(string2);
                if (threadStatistics._deadlockDetectionDurationInMillis >= 0L) {
                    stringBuilder.append("\n Deadlock detection was executed in ").append(threadStatistics._deadlockDetectionDurationInMillis).append(" milliseconds");
                }
                ThreadInfo[] threadInfoArray = threadStatistics._threadInfos;
                if (threadStatistics._deadlockedThreadIds != null) {
                    stringBuilder.append("Deadlocked thread IDs: ").append(Arrays.toString(threadStatistics._deadlockedThreadIds));
                }
                if (threadInfoArray != null) {
                    stringBuilder.append('\n').append('\n');
                    if (threadStatistics._reasonForThreadInfos != null) {
                        stringBuilder.append(threadStatistics._reasonForThreadInfos).append('\n').append('\n');
                    }
                    for (ThreadInfo threadInfo : threadInfoArray) {
                        String string3 = threadInfo.toString();
                        stringBuilder.append(string3);
                    }
                }
                _logger.info((Object)stringBuilder.toString());
                SystemUsageMonitor.this._threadDumper.dumpThreadsIfNeeded(threadMXBean);
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to log system usage statistics", (Throwable)exception);
            }
        }
    }
}

