/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.FeatureStateProvider;
import com.vmware.vise.util.feature.names.Feature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticUtilityFeatureStateProvider
implements FeatureStateProvider {
    private static final Log _logger = LogFactory.getLog(StaticUtilityFeatureStateProvider.class);

    private Map<Feature, FeatureState> buildStatesMap() {
        Feature[] featureArray;
        EnumMap<Feature, FeatureState> enumMap = new EnumMap<Feature, FeatureState>(Feature.class);
        _logger.debug((Object)"Initializing FeatureState static utility");
        com.vmware.vim.featurestateswitch.FeatureState.init();
        for (Feature feature : featureArray = Feature.values()) {
            String string = feature.value();
            Method method = StaticUtilityFeatureStateProvider.getFeatureStateMethod(string);
            if (method == null) continue;
            FeatureState featureState = FeatureState.DISABLED;
            try {
                Object object = method.invoke(null, new Object[0]);
                if (Boolean.TRUE.equals(object)) {
                    featureState = FeatureState.ENABLED;
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                String string2 = "Cannot access state for feature: " + string;
                _logger.error((Object)string2, (Throwable)reflectiveOperationException);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Rerieved feature: %s = %s", new Object[]{string, featureState}));
            }
            enumMap.put(feature, featureState);
        }
        return enumMap;
    }

    private static Method getFeatureStateMethod(String string) {
        try {
            String string2 = "get" + string;
            return com.vmware.vim.featurestateswitch.FeatureState.class.getMethod(string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "No such feature found: " + string;
            _logger.error((Object)string3);
            return null;
        }
    }

    @Override
    public Map<Feature, FeatureState> getAllFeatures() {
        return this.buildStatesMap();
    }
}

