/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import com.vmware.vise.util.http.ConnectionManager;
import com.vmware.vise.util.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class SimpleHttpClient
implements HttpClient {
    private final ConnectionManager connectionManager = new ConnectionManager();

    @Override
    public void setSocketReadTimeout(int n) {
        this.connectionManager.setReadTimeout(n);
    }

    @Override
    public int getSocketReadTimeout() {
        return this.connectionManager.getReadTimeout();
    }

    @Override
    public void setSocketConnectionTimeout(int n) {
        this.connectionManager.setConnectTimeout(n);
    }

    @Override
    public int getSocketConnectionTimeout() {
        return this.connectionManager.getConnectTimeout();
    }

    public String getCookie() {
        return this.connectionManager.getCookie();
    }

    @Override
    public boolean isSessionInitiated() {
        return this.getCookie() != null;
    }

    @Override
    public String executeMethod(String string, Map<String, String> map, Map<String, String> map2) {
        String string2 = null;
        try {
            this.connect(string, map, map2, null);
            string2 = this.connectionManager.getResponseBodyAsString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.connectionManager.close();
        }
        return string2;
    }

    @Override
    public byte[] executeMethodResponseAsBytes(String string, Map<String, String> map, Map<String, String> map2) {
        byte[] byArray = null;
        try {
            this.connect(string, map, map2, null);
            byArray = this.connectionManager.getResponseBodyAsBytes();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.connectionManager.close();
        }
        return byArray;
    }

    @Override
    public InputStream executeMethodResponseAsStream(String string, Map<String, String> map, Map<String, String> map2, Proxy proxy) throws IOException {
        this.connect(string, map, map2, proxy);
        InputStream inputStream = this.connectionManager.getResponseBodyAsStream();
        AutoDisconnectStream autoDisconnectStream = new AutoDisconnectStream(inputStream, this.connectionManager);
        return autoDisconnectStream;
    }

    @Override
    public InputStream executeMethodResponseAsStream(String string, Map<String, String> map, Map<String, String> map2) throws IOException {
        return this.executeMethodResponseAsStream(string, map, map2, null);
    }

    @Override
    public long getContentLength() {
        return this.connectionManager.getContentLength();
    }

    @Override
    public int getStatusCode() {
        return this.connectionManager.getStatusCode();
    }

    @Override
    public Object getSSLSocketFactory() {
        if (this.connectionManager != null) {
            return this.connectionManager.getSSLSocketFactory();
        }
        return null;
    }

    @Override
    public void setSSLSocketFactory(Object object) {
        if (this.connectionManager == null || !(object instanceof SSLSocketFactory)) {
            return;
        }
        this.connectionManager.setSSLSocketFactory((SSLSocketFactory)object);
    }

    @Override
    public Object getHostnameVerifier() {
        if (this.connectionManager != null) {
            return this.connectionManager.getHostnameVerifier();
        }
        return null;
    }

    @Override
    public void setHostnameVerifier(Object object) {
        if (this.connectionManager == null || !(object instanceof HostnameVerifier)) {
            return;
        }
        this.connectionManager.setHostnameVerifier((HostnameVerifier)object);
    }

    private void connect(String string, Map<String, String> map, Map<String, String> map2, Proxy proxy) throws IOException {
        this.connectionManager.init(string, null);
        if (map != null) {
            this.connectionManager.addParameters(map);
        }
        if (map2 != null) {
            this.connectionManager.addHeaders(map2);
        }
        this.connectionManager.connect();
    }

    private static class AutoDisconnectStream
    extends InputStream {
        private final InputStream _actualStream;
        private final ConnectionManager _connectionManager;

        public AutoDisconnectStream(InputStream inputStream, ConnectionManager connectionManager) {
            this._actualStream = inputStream;
            this._connectionManager = connectionManager;
        }

        @Override
        public int available() throws IOException {
            return this._actualStream.available();
        }

        @Override
        public void close() throws IOException {
            this._actualStream.close();
            this._connectionManager.close();
        }

        @Override
        public void mark(int n) {
            this._actualStream.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this._actualStream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this._actualStream.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this._actualStream.read(byArray, n, n2);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this._actualStream.read(byArray);
        }

        @Override
        public void reset() throws IOException {
            this._actualStream.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            return this._actualStream.skip(l);
        }
    }
}

