/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.i18n;

import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class I18nFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(I18nFilter.class);

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        ResourceUtil.extractAndSaveLocale(httpServletRequest);
        if (_logger.isInfoEnabled()) {
            HttpSession httpSession = httpServletRequest.getSession();
            Locale locale = ResourceUtil.getVerifiedAppLocale(httpServletRequest);
            String string = SessionUtil.getHashedSessionId(httpSession);
            _logger.info((Object)("The preferred locale for session " + string + " is set to: " + locale));
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

