/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.internal;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "java-util.properties";
    public static final int SIMPLE_HTTP_CLIENT_CONNECT_TIMEOUT;
    public static final int SIMPLE_HTTP_CLIENT_READ_TIMEOUT;
    public static final List<Pair<String, String>> OP_ID_LOGGING_METHODS_TRACE_LEVEL;
    public static final List<Pair<String, String>> OP_ID_LOGGING_METHODS_WHITELIST_SLOW;

    private static List<Pair<String, String>> parseOpIdLoggingMethodsForTraceLevel(String string) {
        String[] stringArray;
        if (StringUtil.isNullOrWhitespace(string)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>(5);
        for (String string2 : stringArray = string.split(",")) {
            int n = string2.lastIndexOf(".");
            if (n <= 0 || n >= string2.length() - 1) {
                _logger.error((Object)("Invalid TRACE-level method name: " + string2));
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            Pair<String, String> pair = new Pair<String, String>(string3, string4, true);
            arrayList.add(pair);
        }
        return arrayList;
    }

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties(classLoader, CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        SIMPLE_HTTP_CLIENT_CONNECT_TIMEOUT = PropertyUtil.getIntProperty(properties, "simpleHttpClient.connect.timeout", 10000);
        SIMPLE_HTTP_CLIENT_READ_TIMEOUT = PropertyUtil.getIntProperty(properties, "simpleHttpClient.read.timeout", 30000);
        String string = properties.getProperty("opId.logging.methods.traceLevel");
        OP_ID_LOGGING_METHODS_TRACE_LEVEL = Config.parseOpIdLoggingMethodsForTraceLevel(string);
        string = properties.getProperty("opId.logging.methods.whitelist.slow");
        OP_ID_LOGGING_METHODS_WHITELIST_SLOW = Config.parseOpIdLoggingMethodsForTraceLevel(string);
    }
}

