/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class JsonUtil {
    private static ObjectMapper _mapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String escape(String string) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JsonUtil.escape(string, stringWriter).toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    private static Writer escape(String string, Writer writer) throws IOException {
        if (string == null || string.length() == 0) {
            writer.write("\"\"");
            return writer;
        }
        char c = '\u0000';
        int n = string.length();
        writer.write(34);
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write("\\u");
                        String string2 = Integer.toHexString(c);
                        writer.write("0000", 0, 4 - string2.length());
                        writer.write(string2);
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
        return writer;
    }

    public static Map<String, Object> mapFromJson(String string) throws JsonParseException, JsonMappingException, IOException {
        JsonUtil.initializeObjectMapperIfNeeded();
        Map map = (Map)_mapper.readValue(string, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return map;
    }

    public static Object[] arrayFromJson(String string) throws JsonParseException, JsonMappingException, IOException {
        JsonUtil.initializeObjectMapperIfNeeded();
        Object[] objectArray = (Object[])_mapper.readValue(string, Object[].class);
        return objectArray;
    }

    private static void initializeObjectMapperIfNeeded() {
        if (_mapper == null) {
            _mapper = new ObjectMapper();
            _mapper.configure(DeserializationConfig.Feature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        }
    }
}

