/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.logging;

import ch.qos.logback.classic.Level;
import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MXBean;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogUtil {
    private static final Logger _logger = LoggerFactory.getLogger(LogUtil.class);
    private static final Log _opIdLogger = LogFactory.getLog((String)"opId.logger");
    private static final String REQUEST_INFO_KEY = "requestGuid";
    private static final String USER_NAME_KEY = "userName";
    private static final String COMBINED_INFO_KEY = "sessionGuid";
    private static final boolean MDC_SUPPORTED;
    private static final ThreadLocal<ConcurrentMap<String, String>> _localMDC;

    private LogUtil() {
    }

    private static final ThreadLocal<ConcurrentMap<String, String>> buildLocalMDC() {
        return new ThreadLocal<ConcurrentMap<String, String>>(){

            @Override
            protected ConcurrentMap<String, String> initialValue() {
                return new ConcurrentHashMap<String, String>();
            }
        };
    }

    public static boolean isLogContextSupported() {
        return MDC_SUPPORTED;
    }

    static void putIntoMDC(String string, String string2) {
        if (MDC_SUPPORTED) {
            MDC.put((String)string, (String)string2);
        } else {
            _localMDC.get().put(string, string2);
        }
    }

    static String getFromMDC(String string) {
        String string2 = MDC_SUPPORTED ? MDC.get((String)string) : (String)_localMDC.get().get(string);
        return string2;
    }

    static void removeFromMDC(String string) {
        if (MDC_SUPPORTED) {
            MDC.remove((String)string);
        } else {
            _localMDC.get().remove(string);
        }
    }

    static void clearMDC() {
        if (MDC_SUPPORTED) {
            MDC.clear();
        } else {
            _localMDC.get().clear();
        }
    }

    private static void populateMDC(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        try {
            if (httpSession == null) {
                if (httpServletRequest == null) {
                    LogUtil.removeRequestInfoFromLogContext();
                    return;
                }
                httpSession = httpServletRequest.getSession(false);
            }
            String string = SessionUtil.getHashedSessionId(httpSession, false);
            String string2 = SessionUtil.getHashedClientId(httpSession);
            LogUtil.populateMDC(httpServletRequest, httpSession, string, string2);
        }
        catch (Exception exception) {
            _logger.error("Failed to populate the MDC", (Throwable)exception);
        }
    }

    private static void populateMDC(HttpServletRequest httpServletRequest, HttpSession httpSession, String string, String string2) {
        try {
            String string3;
            String string4 = null;
            if (httpSession != null) {
                string4 = (String)SessionUtil.getData("USER_NAME", httpSession);
            }
            if (StringUtil.isNullOrEmpty(string4)) {
                string4 = "_unknown_user_";
            }
            LogUtil.putIntoMDC(USER_NAME_KEY, string4);
            if (httpServletRequest == null) {
                string3 = LogUtil.getFromMDC(REQUEST_INFO_KEY);
            } else {
                string3 = SessionUtil.getHashedRequestId(httpServletRequest);
                if (string3 != null) {
                    LogUtil.putIntoMDC(REQUEST_INFO_KEY, string3);
                }
            }
            if (string3 == null && string == null && string2 == null) {
                LogUtil.removeRequestInfoFromLogContext();
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(25);
            if (string3 != null) {
                stringBuilder.append(string3);
            } else {
                stringBuilder.append("########");
            }
            stringBuilder.append(' ');
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append("######");
            }
            stringBuilder.append(' ');
            if (string2 != null) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append("######");
            }
            String string5 = stringBuilder.toString();
            LogUtil.putIntoMDC(COMBINED_INFO_KEY, string5);
        }
        catch (Exception exception) {
            _logger.error("Failed to populate the MDC", (Throwable)exception);
        }
    }

    public static void putRequestInfoIntoLogContext(HttpServletRequest httpServletRequest) {
        LogUtil.populateMDC(httpServletRequest, null);
    }

    public static void putSessionInfoIntoLogContext(HttpSession httpSession) {
        LogUtil.populateMDC(null, httpSession);
    }

    public static void putSessionInfoIntoLogContext(@Nonnull SessionUtil.HashedSessionInfo hashedSessionInfo) {
        Preconditions.checkNotNull((Object)hashedSessionInfo, (Object)"sessionInfo is null");
        String string = hashedSessionInfo.getHashedSessionId();
        String string2 = hashedSessionInfo.getHashedClientId();
        LogUtil.populateMDC(null, null, string, string2);
    }

    public static void removeRequestInfoFromLogContext() {
        LogUtil.removeFromMDC(COMBINED_INFO_KEY);
        LogUtil.removeFromMDC(REQUEST_INFO_KEY);
        LogUtil.removeFromMDC(USER_NAME_KEY);
    }

    public static void removeSessionInfoFromLogContext() {
        LogUtil.removeFromMDC(COMBINED_INFO_KEY);
        LogUtil.removeFromMDC(USER_NAME_KEY);
        String string = LogUtil.getFromMDC(REQUEST_INFO_KEY);
        if (string != null) {
            LogUtil.putIntoMDC(COMBINED_INFO_KEY, string);
        }
    }

    public static boolean containsRequestInfo() {
        String string = LogUtil.getFromMDC(REQUEST_INFO_KEY);
        return string != null;
    }

    public static String getInfoFromLogContext() {
        String string = LogUtil.getFromMDC(COMBINED_INFO_KEY);
        return string;
    }

    private static void registerLogLeverSetterMXBean() {
        try {
            LogLevelSetter logLevelSetter = new LogLevelSetter();
            ObjectName objectName = new ObjectName(logLevelSetter.getClass().getPackage().getName(), "type", logLevelSetter.getClass().getSimpleName());
            ManagementFactory.getPlatformMBeanServer().registerMBean(logLevelSetter, objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (Exception exception) {
            _logger.error("Failed to register the " + LogLevelSetter.class.getSimpleName() + " bean", (Throwable)exception);
        }
    }

    public static String sanitize(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replace("\n[", "\n  >[");
        return string2;
    }

    public static Log getOpIdLogger() {
        return _opIdLogger;
    }

    static {
        LogUtil.registerLogLeverSetterMXBean();
        MDC.put((String)"#VMW.:MDC_TEST_VALUE:.VMW#", (String)"test");
        String string = MDC.get((String)"#VMW.:MDC_TEST_VALUE:.VMW#");
        MDC_SUPPORTED = "test".equals(string);
        MDC.remove((String)"#VMW.:MDC_TEST_VALUE:.VMW#");
        _localMDC = MDC_SUPPORTED ? null : LogUtil.buildLocalMDC();
    }

    public static enum LogLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }

    public static class LogLevelSetter
    implements LogLevelSetterMXBean {
        @Override
        public void setLogLevel(String string, String string2) throws IllegalArgumentException, UnsupportedOperationException {
            LogLevelSetter.setLogLevelStatic(string, string2);
        }

        public static void setLogLevelStatic(String string, String string2) throws IllegalArgumentException, UnsupportedOperationException {
            if (StringUtil.isNullOrWhitespace(string)) {
                throw new IllegalArgumentException("The logger name shouldn't be null or whitespace");
            }
            if (StringUtil.isNullOrWhitespace(string2)) {
                throw new IllegalArgumentException("The log level shouldn't be null or whitespace");
            }
            Logger logger = LoggerFactory.getLogger((String)string);
            if (logger instanceof ch.qos.logback.classic.Logger) {
                Level level = Level.toLevel((String)string2, null);
                if (level == null) {
                    throw new IllegalArgumentException("Unsupported log level: " + string2);
                }
                ((ch.qos.logback.classic.Logger)logger).setLevel(level);
                return;
            }
            Class<?> clazz = logger.getClass();
            String string3 = clazz.getCanonicalName();
            if ("org.slf4j.impl.Log4jLoggerAdapter".equals(string3)) {
                try {
                    Field field = ReflectionUtil.getSingleFieldOfType(clazz, org.apache.log4j.Logger.class, true);
                    field.setAccessible(true);
                    org.apache.log4j.Logger logger2 = (org.apache.log4j.Logger)field.get(logger);
                    org.apache.log4j.Level level = org.apache.log4j.Level.toLevel((String)string2, null);
                    if (level == null) {
                        throw new IllegalArgumentException("Unsupported log level: " + string2);
                    }
                    logger2.setLevel(level);
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException("Failed to set the level of logger " + string + " to " + string2, exception);
                }
            }
            throw new UnsupportedOperationException("Unsupported implementation of " + Logger.class.getCanonicalName() + ": " + logger.getClass().getCanonicalName() + ". Can't set log level.");
        }
    }

    @MXBean
    public static interface LogLevelSetterMXBean {
        public void setLogLevel(String var1, String var2) throws IllegalArgumentException, UnsupportedOperationException;
    }
}

