/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.messaging;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.util.messaging.WebSocketBasedMessagingServlet;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class MessagingServiceImpl
implements MessagingService {
    private static final Log _logger = LogFactory.getLog(MessagingServiceImpl.class);

    @Override
    public void sendMessage(Message message) {
        ObjectMapper objectMapper = new ObjectMapper();
        String string = null;
        try {
            string = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception exception) {
            _logger.error((Object)"Exception while converting message to json: ", (Throwable)exception);
        }
        if (StringUtil.isNullOrEmpty(string)) {
            _logger.error((Object)"Empty message will not be sent.");
            return;
        }
        MessagingServiceImpl.sendMessage(string);
    }

    private static void sendMessage(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            _logger.error((Object)"Empty message will not be sent.");
            return;
        }
        Set set = (Set)SessionUtil.getData("appwebsocketconnection");
        if (set == null || set.size() == 0) {
            return;
        }
        for (WebSocketBasedMessagingServlet.AppMessageInbound appMessageInbound : set.toArray(new WebSocketBasedMessagingServlet.AppMessageInbound[0])) {
            try {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                appMessageInbound.getWsOutbound().writeTextMessage(charBuffer);
            }
            catch (IOException iOException) {
                _logger.error((Object)"Could not send message on websocket.", (Throwable)iOException);
            }
        }
    }
}

