/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.osgi;

import com.vmware.vise.util.service.ClassLoaderService;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGIClassLoaderService
implements ClassLoaderService {
    private final BundleContext _bundleContext;
    private final ConcurrentHashMap<String, Class> _classByClassName = new ConcurrentHashMap();

    public OSGIClassLoaderService(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    public <T> Class<T> loadClass(String string) throws ClassNotFoundException {
        if (this._classByClassName.containsKey(string)) {
            return this._classByClassName.get(string);
        }
        Class clazz = this.findClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(String.format("No installed active bundle could be found that can load class %s", string));
        }
        return clazz;
    }

    @Override
    public synchronized void expireCache() {
        this._classByClassName.clear();
    }

    private Class findClass(String string) {
        Bundle[] bundleArray;
        for (Bundle bundle : bundleArray = this._bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            try {
                Class clazz = bundle.loadClass(string);
                this._classByClassName.put(string, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

