/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.reflection;

import com.vmware.vise.util.ValidationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassDirectory {
    private static final Log _logger = LogFactory.getLog(ClassDirectory.class);
    private static final int DEFAULT_CACHE_SIZE = 32;
    private static final int MAX_CACHE_SIZE = 1000;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private static final boolean CACHE_ACCESS_ORDER = true;
    private final ClassLoader _classLoader;
    private final Set<String> _packages;
    private final Map<String, Class<?>> _classByType;

    public ClassDirectory(Collection<String> collection, ClassLoader classLoader, Integer n) {
        ValidationUtil.paramsNotNull(collection, classLoader);
        this._packages = Collections.unmodifiableSet(new HashSet<String>(collection));
        this._classLoader = classLoader;
        final int n2 = ClassDirectory.getCacheSize(n);
        LinkedHashMap linkedHashMap = new LinkedHashMap<String, Class<?>>(n2, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Class<?>> entry) {
                return this.size() > n2;
            }
        };
        this._classByType = Collections.synchronizedMap(linkedHashMap);
    }

    public Class<?> getClass(String string) {
        ValidationUtil.paramsNotNull(string);
        Class<?> clazz = this._classByType.get(string);
        if (clazz != null) {
            return clazz;
        }
        List<Class<?>> list = this.getClassesFromPackages(string);
        if (list.isEmpty()) {
            _logger.info((Object)("No binding class found for " + string));
            return null;
        }
        if (list.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("More than one binding class registered for " + string + "\n");
            for (Class<?> clazz2 : list) {
                stringBuilder.append(clazz2.getName() + "\n");
            }
            throw new IllegalStateException(stringBuilder.toString());
        }
        clazz = list.get(0);
        this._classByType.put(string, clazz);
        return clazz;
    }

    private static int getCacheSize(Integer n) {
        if (n == null) {
            return 32;
        }
        if (n < 0 || n > 1000) {
            return 32;
        }
        int n2 = n;
        return n2;
    }

    private List<Class<?>> getClassesFromPackages(String string) {
        assert (string != null);
        LinkedList linkedList = new LinkedList();
        for (String string2 : this._packages) {
            String string3 = string2 + "." + string;
            try {
                Class<?> clazz = this._classLoader.loadClass(string3);
                linkedList.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return linkedList;
    }
}

