/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.reflection;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.reflection.TooManyFieldsException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class ReflectionUtil {
    private static List<Field> findFieldsOfType(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2, boolean bl3, List<Field> list) throws NoSuchFieldException, TooManyFieldsException {
        Field[] fieldArray;
        if (clazz == null) {
            throw new IllegalArgumentException("The owner should not be null");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("The fieldType should not be null");
        }
        Object object = fieldArray = clazz.getDeclaredFields();
        int n = ((Field[])object).length;
        for (int i = 0; i < n; ++i) {
            Field field = object[i];
            Class<?> clazz3 = field.getType();
            if ((!bl || !clazz2.equals(clazz3)) && (bl || !clazz2.isAssignableFrom(clazz3))) continue;
            if (list == null) {
                list = new LinkedList<Field>();
            } else if (bl3) {
                throw new TooManyFieldsException("Class " + clazz.getCanonicalName() + " contains more than one field of type " + clazz2.getCanonicalName() + ": " + fieldArray);
            }
            list.add(field);
        }
        if (bl2 && (object = clazz.getSuperclass()) != null) {
            list = ReflectionUtil.findFieldsOfType(object, clazz2, bl, bl2, bl3, list);
        }
        if (list == null || list.size() == 0) {
            throw new NoSuchFieldException("Class " + clazz.getCanonicalName() + " doesn't contain a field of type " + clazz2.getCanonicalName());
        }
        return list;
    }

    public static List<Field> getAllFieldsOfType(Class<?> clazz, Class<?> clazz2, boolean bl) {
        List<Field> list = null;
        try {
            list = ReflectionUtil.findFieldsOfType(clazz, clazz2, bl, true, false, null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (TooManyFieldsException tooManyFieldsException) {
            // empty catch block
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static Field getSingleFieldOfType(Class<?> clazz, Class<?> clazz2, boolean bl) throws NoSuchFieldException, TooManyFieldsException {
        List<Field> list = ReflectionUtil.findFieldsOfType(clazz, clazz2, bl, true, true, null);
        Field field = list.get(0);
        return field;
    }

    public static Class<?> getCommonSuperclass(Class<?> ... classArray) {
        if (classArray == null || classArray.length == 0) {
            return null;
        }
        if (classArray.length == 1) {
            return classArray[0];
        }
        if (ArrayUtil.contains(null, classArray).booleanValue()) {
            return null;
        }
        block0: for (Class<?> clazz = classArray[0]; clazz != null; clazz = clazz.getSuperclass()) {
            for (int i = 1; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                if (clazz.isAssignableFrom(clazz2)) continue;
                continue block0;
            }
            return clazz;
        }
        return null;
    }

    public static List<Class<?>> getCommonSupertypes(Class<?> ... classArray) {
        if (classArray == null || classArray.length == 0) {
            return Collections.emptyList();
        }
        if (classArray.length == 1) {
            if (classArray[0] != null) {
                return Collections.singletonList(classArray[0]);
            }
            return Collections.emptyList();
        }
        classArray = ArrayUtil.removeDuplicates(classArray);
        List<ClassAndLevel> list = null;
        for (Class<?> clazz : classArray) {
            if (clazz == null) {
                return Collections.emptyList();
            }
            List<ClassAndLevel> list2 = ReflectionUtil.getTypeHierarchy(clazz);
            if (!(list = list == null ? CollectionUtil.removeDuplicates(list2) : ReflectionUtil.mergeTypeHierarchies(list, list2)).isEmpty()) continue;
            return Collections.emptyList();
        }
        Collections.sort(list);
        ArrayList arrayList = new ArrayList(list.size());
        for (ClassAndLevel classAndLevel : list) {
            arrayList.add(classAndLevel._class);
        }
        return arrayList;
    }

    @Nonnull
    private static List<ClassAndLevel> getTypeHierarchy(@Nonnull Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<ClassAndLevel> arrayList = new ArrayList<ClassAndLevel>(10);
        arrayList.add(new ClassAndLevel(clazz, 0));
        int n = 1;
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            for (int i = n2; i < n3; ++i) {
                Class<?>[] classArray;
                Class clazz2 = ((ClassAndLevel)arrayList.get(i))._class;
                Class clazz3 = clazz2.getSuperclass();
                if (clazz3 != null && !clazz3.equals(Object.class)) {
                    arrayList.add(new ClassAndLevel(clazz3, n));
                }
                for (Class<?> clazz4 : classArray = clazz2.getInterfaces()) {
                    arrayList.add(new ClassAndLevel(clazz4, n));
                }
            }
            n2 = n3;
            n3 = arrayList.size();
            ++n;
        }
        if (!clazz.equals(Object.class) && Object.class.isAssignableFrom(clazz)) {
            arrayList.add(new ClassAndLevel(Object.class, Integer.MAX_VALUE));
        }
        return arrayList;
    }

    private static List<ClassAndLevel> mergeTypeHierarchies(List<ClassAndLevel> list, List<ClassAndLevel> list2) {
        ArrayList<ClassAndLevel> arrayList = new ArrayList<ClassAndLevel>(20);
        for (ClassAndLevel classAndLevel : list) {
            int n = list2.indexOf(classAndLevel);
            if (n < 0) continue;
            ClassAndLevel classAndLevel2 = list2.get(n);
            if (classAndLevel._level >= classAndLevel2._level) {
                arrayList.add(classAndLevel);
                continue;
            }
            arrayList.add(classAndLevel2);
        }
        return arrayList;
    }

    public static String getName(Class<?> clazz) {
        String string = clazz.getCanonicalName();
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    public static String getBasicSignatureInfo(@Nonnull Method method) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ReflectionUtil.getTypeName(method.getReturnType())).append(' ');
            stringBuilder.append(ReflectionUtil.getTypeName(method.getDeclaringClass())).append('.');
            stringBuilder.append(method.getName()).append('(');
            Class<?>[] classArray = method.getParameterTypes();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(ReflectionUtil.getTypeName(classArray[i]));
                if (i >= n - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    private static String getTypeName(@Nonnull Class<?> clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    private static class ClassAndLevel
    implements Comparable<ClassAndLevel> {
        private final Class<?> _class;
        private int _level;

        public ClassAndLevel(Class<?> clazz, int n) {
            this._class = clazz;
            this._level = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            ClassAndLevel classAndLevel = (ClassAndLevel)object;
            boolean bl = this._class.equals(classAndLevel._class);
            return bl;
        }

        public int hashCode() {
            return this._class.hashCode();
        }

        public String toString() {
            return "[" + this._class.getName() + "," + this._level + "]";
        }

        @Override
        public int compareTo(ClassAndLevel classAndLevel) {
            if (this._level < classAndLevel._level) {
                return -1;
            }
            if (this._level > classAndLevel._level) {
                return 1;
            }
            boolean bl = this._class.isInterface();
            boolean bl2 = classAndLevel._class.isInterface();
            if (bl && !bl2) {
                return 1;
            }
            if (!bl && bl2) {
                return -1;
            }
            int n = this._class.getName().compareTo(classAndLevel._class.getName());
            return n;
        }
    }
}

