/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.specs;

import com.vmware.vise.util.IPluginRef;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.specs.ObjectSpec;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComponentSpec
implements IUID,
IPluginRef {
    protected String _uid;
    public ObjectSpec componentClass;

    @Override
    public String getUid() {
        return this._uid;
    }

    @Override
    public void setUid(String string) {
        this._uid = string;
        if (this.componentClass != null) {
            this.componentClass.setUid(string);
        }
    }

    @Override
    public void setPluginRef(IdVersionPair idVersionPair) {
        if (this.componentClass != null) {
            this.componentClass.pluginRef = idVersionPair;
        }
    }

    public ComponentSpec() {
    }

    public ComponentSpec(String string) throws IOException {
        Document document = XMLUtil.parseXml(string);
        this.parseComponentClass(document);
        Element element = XMLUtil.getChildTag(document.getDocumentElement(), "uid");
        if (element != null) {
            this._uid = element.getTextContent();
        }
    }

    protected void parseComponentClass(Document document) throws IOException {
        this.componentClass = new ObjectSpec();
        Element element = XMLUtil.getChildTag(document.getDocumentElement(), "componentClass");
        Element element2 = XMLUtil.getChildTag(element, "className");
        this.componentClass.className = element2 != null ? element2.getTextContent().trim() : XMLUtil.getAttribute(element, "className");
        Element element3 = XMLUtil.getChildTag(element, "object");
        if (element3 != null && (element3 = XMLUtil.getChildTag(element3, "root")) != null) {
            this.componentClass.objectXml = XMLUtil.xmlToString(element3);
        }
    }
}

