/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AbsoluteDataValuesProvider;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.hacks.CisDsHttpServletRequest;
import com.vmware.vise.vim.messaging.hacks.CisDsHttpSession;
import com.vmware.vise.vim.messaging.util.WebUtils;
import com.vmware.vise.vim.messaging.websocket.Controller;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LiveUpdatesSubscriptionController
implements Controller {
    private static final Log _logger = LogFactory.getLog(LiveUpdatesSubscriptionController.class);
    private final Monitor _monitor;
    private final Map<String, List<AbsoluteDataValuesProvider<?>>> _absoluteDataValuesProvidersByDestination;
    private final ChangeNotifierManager _changeNotifierManager;

    public LiveUpdatesSubscriptionController(Monitor monitor, Map<String, List<AbsoluteDataValuesProvider<?>>> map, ChangeNotifierManager changeNotifierManager) {
        this._monitor = monitor;
        this._absoluteDataValuesProvidersByDestination = map;
        this._changeNotifierManager = changeNotifierManager;
    }

    public Object handleRequest(Object object) {
        String string = object.toString().split("destination:")[1];
        _logger.debug((Object)"Initializing Live Updates Pipeline ...");
        this._changeNotifierManager.configure(string);
        this._monitor.monitorEvents(string);
        this._changeNotifierManager.commitConfiguration();
        _logger.debug((Object)"Live Updates Pipeline Ready!");
        PartialUpdate<?> partialUpdate = this.getAvailableDataValuesByDestination(string);
        partialUpdate.destination = string;
        _logger.debug((Object)"Available absolute values are retrieved!");
        return partialUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartialUpdate<?> getAvailableDataValuesByDestination(String string) {
        PartialUpdate partialUpdate;
        List<AbsoluteDataValuesProvider<?>> list = this._absoluteDataValuesProvidersByDestination.get(string);
        AbsoluteDataValuesProvider<Object> absoluteDataValuesProvider = null;
        absoluteDataValuesProvider = list == null || list.isEmpty() ? new AbsoluteDataValuesProvider<Object>(){

            public PartialUpdate<Object> getAvailableDataValues() {
                return PartialUpdate.empty();
            }
        } : list.get(0);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this.createFakeHttpRequest());
            partialUpdate = absoluteDataValuesProvider.getAvailableDataValues();
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
        return partialUpdate;
    }

    private HttpServletRequest createFakeHttpRequest() {
        CisDsHttpSession cisDsHttpSession = new CisDsHttpSession(UUID.randomUUID().toString());
        cisDsHttpSession.setAttribute("#clientId#", WebUtils.getCurrentClientId());
        return new CisDsHttpServletRequest(cisDsHttpSession);
    }
}

