/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectDetailsUpdatesProcessor
implements CdcProcessor<Object> {
    static final String HAS_OBJECT_STATE_METADATA_ATTRIBUTE = "hasObjectStateProperty";
    private static final Map<String, Set<String>> _objectStatePropertiesByType = Collections.unmodifiableMap(ObjectDetailsUpdatesProcessor.initObjectRepresenationPropertiesMap());

    public ObjectDetailsUpdatesProcessor() {
        ObjectDetailsUpdatesProcessor.initObjectRepresenationPropertiesMap();
    }

    public PartialUpdate<Object> process(List<ResourceChange> list) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        if (list == null || list.isEmpty()) {
            return partialUpdate;
        }
        for (ResourceChange resourceChange : list) {
            Object object = resourceChange.getResource();
            if (resourceChange.getKind() != ResourceChange.Kind.UPDATE) continue;
            if (object instanceof String) {
                object = VapiUriSchemeUtil.createUri((String)resourceChange.getResourceType(), (String)((String)resourceChange.getResource()));
            }
            PartialUpdateItem partialUpdateItem = PartialUpdateItem.of((Object)object, null);
            partialUpdateItem.assignMetadata(HAS_OBJECT_STATE_METADATA_ATTRIBUTE, (Object)this.hasObjectStateProperty(resourceChange));
            partialUpdate.updates.add(partialUpdateItem);
        }
        return partialUpdate;
    }

    private static Map<String, Set<String>> initObjectRepresenationPropertiesMap() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(ClusterComputeResource.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(Datacenter.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("hostMount");
        hashSet.add("summary.accessible");
        hashSet.add("overallStatus");
        hashSet.add("summary.maintenanceMode");
        hashMap.put(Datastore.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashSet.add("isUplinkPortgroup");
        hashSet.add("tag");
        hashMap.put(DistributedVirtualPortgroup.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(DistributedVirtualSwitch.class.getSimpleName(), hashSet);
        hashMap.put(VmwareDistributedVirtualSwitch.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("isRootFolder");
        hashMap.put(Folder.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("runtime.connectionState");
        hashSet.add("runtime.powerState");
        hashSet.add("overallStatus");
        hashSet.add("summary.rebootRequired");
        hashSet.add("runtime");
        hashMap.put(HostSystem.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(Network.class.getSimpleName(), hashSet);
        hashMap.put(OpaqueNetwork.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(ResourcePool.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(StoragePod.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("vAppConfig.managedBy");
        hashSet.add("isSuspended");
        hashSet.add("summary.suspended");
        hashSet.add("powerState");
        hashSet.add("summary.vAppState");
        hashSet.add("summary");
        hashMap.put(VirtualApp.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("config.template");
        hashSet.add("runtime.connectionState");
        hashSet.add("ftRole");
        hashSet.add("config.ftInfo.role");
        hashSet.add("config.managedBy");
        hashSet.add("runtime.question");
        hashSet.add("overallStatus");
        hashSet.add("runtime.powerState");
        hashSet.add("runtime.faultToleranceState");
        hashMap.put(VirtualMachine.class.getSimpleName(), hashSet);
        return hashMap;
    }

    private boolean hasObjectStateProperty(ResourceChange resourceChange) {
        List list = resourceChange.getProperties();
        if (list == null) {
            return false;
        }
        Set<String> set = _objectStatePropertiesByType.get(resourceChange.getResourceType());
        if (set == null) {
            return false;
        }
        for (String string : list) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }
}

