/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.websocket.MessageSendingOperations;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutboundMessageHandler {
    private final MessageSendingOperations messageTemplate;
    private static final Log _logger = LogFactory.getLog(OutboundMessageHandler.class);

    public OutboundMessageHandler(MessageSendingOperations messageSendingOperations) {
        this.messageTemplate = messageSendingOperations;
    }

    public void sendToWebsocket(PartialUpdate<?> partialUpdate) {
        if (partialUpdate == null) {
            _logger.warn((Object)"[LiveRefresh] Null PartialUpdate before WS send.");
            return;
        }
        int n = partialUpdate.updates.size();
        int n2 = partialUpdate.deleted.size();
        if (n == 0 && n2 == 0) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            if (partialUpdate.timeWhenUpdateIsPushedToTheStream == 0L || partialUpdate.timeWhenChangeIsReceived == 0L) {
                _logger.debug((Object)String.format("[LiveRefresh] Sending (%d) updates and (%d) deletes to WS for destination: [%s].", n, n2, partialUpdate.destination));
            } else {
                long l = System.currentTimeMillis();
                _logger.debug((Object)String.format("[LiveRefresh] (%s) contains (%d) updates and (%d) deletes. Total VC -> WS latency for destination: (%s) is %d milliseconds. This includes %d milliseconds idle time and %d milliseconds processing time.", partialUpdate.changeId, n, n2, partialUpdate.destination, l - partialUpdate.timeWhenChangeIsReceived, l - partialUpdate.timeWhenUpdateIsPushedToTheStream, partialUpdate.timeWhenUpdateIsPushedToTheStream - partialUpdate.timeWhenChangeIsReceived));
            }
        }
        try {
            this.messageTemplate.sendMessage(partialUpdate);
        }
        catch (IOException iOException) {
            _logger.error((Object)("[LiveRefresh] Cannot send to websocket:" + iOException.getMessage()));
        }
    }

    public void onClose(Runnable runnable) {
        this.messageTemplate.setOnClose(runnable);
    }
}

