/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.FilterRegistry;
import com.vmware.vise.vim.messaging.OutboundMessageHandler;
import com.vmware.vise.vim.messaging.Session;
import com.vmware.vise.vim.messaging.streams.Streams;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import reactor.rx.Stream;

public final class UpdatesManager {
    private static final Log _logger = LogFactory.getLog(UpdatesManager.class);
    private final Streams _streams;
    private final LinkedVcGroupRegistry _linkedVcGroupRegistry;
    private final ChangeNotifierManager _changeNotificationManager;
    private HttpServletRequest _fakeHttpRequest;
    private String _userName;
    private final FilterRegistry _filterRegistry;
    private final FeatureStateService _featureStateService;
    private final ConfigurationService _configurationService;

    public UpdatesManager(Streams streams, LinkedVcGroupRegistry linkedVcGroupRegistry, ChangeNotifierManager changeNotifierManager, FilterRegistry filterRegistry, FeatureStateService featureStateService, ConfigurationService configurationService) {
        this._configurationService = configurationService;
        ValidationUtil.paramsNotNull((Object[])new Object[]{streams, linkedVcGroupRegistry, featureStateService});
        this._streams = streams;
        this._linkedVcGroupRegistry = linkedVcGroupRegistry;
        this._changeNotificationManager = changeNotifierManager;
        this._filterRegistry = filterRegistry;
        this._featureStateService = featureStateService;
    }

    public void subscribe(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (string.equals("/topic/navTree") || string.equals("/topic/object-details")) {
            return;
        }
        Set<VcService> set = this.getCurrentUserVCs();
        this.createPCfilters(string, set);
    }

    public void init(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        this._fakeHttpRequest = Session.createFakeHttpRequest(string);
        Set<VcService> set = this.getCurrentUserVCs();
        this.saveUsername(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Stream<PartialUpdate<?>>> createUpdatesStreams() {
        ArrayList arrayList = new ArrayList();
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            arrayList.addAll(this.createPropertyCollectorStreams());
            arrayList.addAll(this.createAlarmIssuesStreams());
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChangeNotifiers() {
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this._changeNotificationManager.closeNotifiers();
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private List<Stream<PartialUpdate<?>>> createAlarmIssuesStreams() {
        ArrayList arrayList = new ArrayList();
        try {
            boolean bl;
            boolean bl2 = LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService);
            boolean bl3 = bl = !LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService);
            if (bl2 && bl) {
                arrayList.add(this._streams.alarmIssueStream.createStream(this._userName, this._fakeHttpRequest));
                arrayList.add(this._streams.mutationOperationStream.createStream());
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Alarms Stream failed to be created");
        }
        return arrayList;
    }

    public void registerHandlerForTaskRegistryStream(OutboundMessageHandler outboundMessageHandler) {
        this._streams.taskRegistryStream.registerMessageHandler(outboundMessageHandler);
    }

    public void unregisterHandlerForTaskRegistryStream(OutboundMessageHandler outboundMessageHandler) {
        this._streams.taskRegistryStream.unregisterMessageHandler(outboundMessageHandler);
    }

    private List<Stream<PartialUpdate<?>>> createPropertyCollectorStreams() {
        ArrayList arrayList = new ArrayList();
        try {
            Set<VcService> set = this.getCurrentUserVCs();
            if (!set.isEmpty()) {
                VcService[] vcServiceArray = set.toArray(new VcService[0]);
                for (int i = 0; i < set.size(); ++i) {
                    VcService vcService = vcServiceArray[i];
                    arrayList.add(this._streams.pcStream.createStream(this._userName, this._fakeHttpRequest, vcService, this._filterRegistry));
                }
            } else {
                _logger.error((Object)"[LiveRefresh] No Property Collector Streams were created");
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Property Collector Streams failed to be created");
        }
        return arrayList;
    }

    private void saveUsername(Set<VcService> set) {
        if (set.isEmpty()) {
            return;
        }
        for (VcService vcService : set) {
            VcServiceConnectionInfo vcServiceConnectionInfo;
            if (vcService == null || (vcServiceConnectionInfo = vcService.getConnectionInfo()) == null) {
                _logger.error((Object)"VC ConnectionInfo is null");
                continue;
            }
            UserSession userSession = vcServiceConnectionInfo.getUserSession();
            if (userSession == null) {
                _logger.error((Object)("UserSession is not active for vc:" + vcService.getServiceGuid()));
                continue;
            }
            if (this._userName != null) continue;
            this._userName = userSession.userName;
            if (this._userName == null) continue;
            break;
        }
    }

    private void createPCfilters(String string, Set<VcService> set) {
        for (VcService vcService : set) {
            List<ManagedObjectReference> list = this._streams.pcStream.registerFilter(string, vcService);
            for (ManagedObjectReference managedObjectReference : list) {
                this._filterRegistry.add(managedObjectReference, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<VcService> getCurrentUserVCs() {
        HashSet<VcService> hashSet = new HashSet<VcService>();
        try {
            LinkedVcGroup[] linkedVcGroupArray;
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
                if (linkedVcGroup == null) continue;
                for (VcService vcService : linkedVcGroup.getVcServices()) {
                    if (vcService == null) continue;
                    hashSet.add(vcService);
                }
            }
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
        return hashSet;
    }

    public String getUsername() {
        return this._userName;
    }
}

