/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.impl;

import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.Session;
import com.vmware.vise.vim.messaging.util.WebUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ChangeListener {
    private static final Log _logger = LogFactory.getLog(ChangeListener.class);
    protected HttpServletRequest _fakeHttpRequest;
    protected String _clientId;
    private final ChangeNotifierManager _changeNotifierManager;
    protected final ConfigurationService _configurationService;
    protected final Monitor _monitor;

    public ChangeListener(Monitor monitor, ChangeNotifierManager changeNotifierManager, ConfigurationService configurationService) {
        this._changeNotifierManager = changeNotifierManager;
        this._monitor = monitor;
        this._configurationService = configurationService;
    }

    public synchronized void startup() throws Exception {
        this._clientId = WebUtils.getCurrentClientId();
        this._fakeHttpRequest = Session.createFakeHttpRequest(this._clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(ChangeNotifier changeNotifier, IllegalStateException illegalStateException) {
        _logger.error((Object)"Error processing alarm updates.", (Throwable)illegalStateException);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this._changeNotifierManager.reconfigureAndCommit(changeNotifier);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }
}

