/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.streams;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AlarmIssueProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.utils.PollingPublisher;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.Environment;
import reactor.fn.Function;
import reactor.rx.Stream;
import reactor.rx.Streams;

public final class AlarmIssueStream {
    private static final Log _logger = LogFactory.getLog(AlarmIssueStream.class);
    private static final int _DEFAULT_REFRESH_RATE = 60;
    private static final String _ALARMS_REFRESH_RATE_KEY = "alarms.refresh.rate";
    private Environment _environment;
    private ConfigurationService _configurationService;
    private AlarmIssueProcessor<?> _alarmIssueProcessor;

    public AlarmIssueStream(Environment environment) {
        this._environment = environment;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void setAlarmIssueProcessor(AlarmIssueProcessor<?> alarmIssueProcessor) {
        this._alarmIssueProcessor = alarmIssueProcessor;
    }

    public Stream<PartialUpdate<?>> createStream(String string, HttpServletRequest httpServletRequest) {
        PollingPublisher pollingPublisher = new PollingPublisher(this.getRefreshRate(), TimeUnit.SECONDS);
        Stream stream = Streams.create((Publisher)pollingPublisher).concatMap(this.checkAlarmIssues(string, httpServletRequest, pollingPublisher));
        return stream;
    }

    private Function<Object, Publisher<? extends PartialUpdate<?>>> checkAlarmIssues(String string, final HttpServletRequest httpServletRequest, final PollingPublisher pollingPublisher) {
        return new Function<Object, Publisher<? extends PartialUpdate<?>>>(){

            public Publisher<PartialUpdate<?>> apply(Object object) {
                return Streams.create((Publisher)new Publisher<PartialUpdate<?>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void subscribe(Subscriber<? super PartialUpdate<?>> subscriber) {
                        boolean bl = true;
                        try {
                            if (AlarmIssueStream.this._alarmIssueProcessor == null) {
                                return;
                            }
                            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                            PartialUpdate partialUpdate = AlarmIssueStream.this._alarmIssueProcessor.process();
                            if (!partialUpdate.isEmpty()) {
                                subscriber.onNext((Object)partialUpdate);
                            }
                            subscriber.onComplete();
                        }
                        catch (Exception exception) {
                            _logger.error((Object)("[LiveRefresh] AlarmIssueStream error: " + exception.getMessage()), (Throwable)exception);
                            subscriber.onError((Throwable)exception);
                        }
                        finally {
                            if (bl) {
                                pollingPublisher.scheduleTaskIfNotScheduled();
                            }
                            SessionUtil.setHttpRequest(null);
                        }
                    }
                }).subscribeOn(AlarmIssueStream.this._environment.getDispatcher("threadPoolExecutor"));
            }
        };
    }

    private int getRefreshRate() {
        if (this._configurationService == null) {
            return 60;
        }
        String string = this._configurationService.getProperty(_ALARMS_REFRESH_RATE_KEY);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return 60;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 10 || n > 600) {
                n = 60;
            }
            return n;
        }
        catch (Exception exception) {
            return 60;
        }
    }
}

