/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.utils;

import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.processor.CancelException;

public class PollingPublisher
implements Publisher<Object> {
    private static final Log _logger = LogFactory.getLog(PollingPublisher.class);
    private static final Object DUMMY_OBJECT = new Object();
    private static final ScheduledThreadPoolExecutor _pollingExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new WorkerThreadFactory("LiveUpdates-polling"));
    private PollingTask _pollingTask = null;
    private boolean _canRescheduleTask;
    private final long _interval;
    private final TimeUnit _unit;
    private boolean pollingStopped;

    public PollingPublisher(long l, TimeUnit timeUnit) {
        this._interval = l;
        this._unit = timeUnit;
        this.pollingStopped = false;
    }

    public void subscribe(Subscriber<Object> subscriber) {
        if (this._pollingTask == null) {
            this._pollingTask = new PollingTask(subscriber);
        }
        this._canRescheduleTask = true;
        this.scheduleTaskIfNotScheduled();
    }

    public void stopPolling() {
        this.pollingStopped = true;
    }

    public void startPolling() {
        this.pollingStopped = false;
        this._canRescheduleTask = true;
        this.scheduleTaskIfNotScheduled();
    }

    public void scheduleTaskIfNotScheduled() {
        if (this._pollingTask == null || this.pollingStopped || !this._canRescheduleTask) {
            return;
        }
        _pollingExecutor.schedule(this._pollingTask, this._interval, this._unit);
        this._canRescheduleTask = false;
    }

    private class PollingTask
    implements Runnable {
        private final Subscriber<Object> subscriber;

        PollingTask(Subscriber<Object> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void run() {
            if (PollingPublisher.this.pollingStopped) {
                return;
            }
            try {
                PollingPublisher.this._canRescheduleTask = true;
                this.subscriber.onNext(DUMMY_OBJECT);
            }
            catch (CancelException cancelException) {
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)"CancelException in polling task:", (Throwable)cancelException);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Error in polling task:", (Throwable)exception);
            }
        }
    }
}

