/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb;

import com.vmware.samples.chassisb.ModelObjectUriResolver;
import com.vmware.samples.chassisb.ObjectStore;
import com.vmware.samples.chassisb.ResultItemComparator;
import com.vmware.samples.chassisb.model.ModelObject;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="HostSystem,samples:Rack,samples:ChassisB")
public class ChassisRackVSphereDataAdapter
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ChassisRackVSphereDataAdapter.class);
    public static final String RACK_TYPE = "samples:Rack";
    public static final String CHASSIS_TYPE = "samples:ChassisB";
    public static final String HOST_TYPE = "HostSystem";
    private static final Set<RelationDescriptor> SUPPORTED_RELATIONS = new HashSet<RelationDescriptor>(Arrays.asList(new RelationDescriptor("samples:Rack", "chassis", "samples:ChassisB"), new RelationDescriptor("samples:ChassisB", "rack", "samples:Rack"), new RelationDescriptor("samples:ChassisB", "host", "HostSystem"), new RelationDescriptor("HostSystem", "chassis", "samples:ChassisB"), new RelationDescriptor("HostSystem", "host", "samples:ChassisB")));
    private static final Map<RelationDescriptor, RelationDescriptor> INVERSE_BY_FORWARD = new HashMap<RelationDescriptor, RelationDescriptor>();
    private static final ResultItem[] EMPTY_RESULT_ITEMS;
    private final DataService _dataService;
    private final ModelObjectUriResolver _uriResolver;
    private final VimObjectReferenceService _objRefService;
    private final ObjectStore _objectStore;
    private static boolean _hostRelationsInitialized;

    public ChassisRackVSphereDataAdapter(DataService dataService, ModelObjectUriResolver modelObjectUriResolver, VimObjectReferenceService vimObjectReferenceService, ObjectStore objectStore) {
        if (dataService == null || vimObjectReferenceService == null || modelObjectUriResolver == null) {
            throw new IllegalArgumentException("constructor args cannot be null.");
        }
        this._dataService = dataService;
        this._uriResolver = modelObjectUriResolver;
        this._objRefService = vimObjectReferenceService;
        this._objectStore = objectStore;
    }

    public Response getData(RequestSpec requestSpec) {
        if (requestSpec == null) {
            throw new IllegalArgumentException("request must be non-null.");
        }
        Response response = requestSpec.querySpec;
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>(((QuerySpec[])response).length);
        for (QuerySpec querySpec : response) {
            ResultSet resultSet = this.processQuery(querySpec);
            arrayList.add(resultSet);
        }
        Response response2 = new Response();
        response2.resultSet = arrayList.toArray(new ResultSet[0]);
        return response2;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        if (!this.validateQuerySpec(querySpec)) {
            return resultSet;
        }
        this.initializeHostRelations();
        List<ResultItem> list = this.processConstraint(querySpec.resourceSpec.constraint, querySpec.resourceSpec.propertySpecs);
        resultSet.totalMatchedObjectCount = list != null ? list.size() : 0;
        resultSet.items = this.adjustResultItems(list, querySpec.resultSpec);
        resultSet.queryName = querySpec.name;
        return resultSet;
    }

    private ResultItem[] adjustResultItems(List<ResultItem> list, ResultSpec resultSpec) {
        int n;
        ResultItem[] resultItemArray = list.toArray(new ResultItem[list.size()]);
        int n2 = resultSpec.offset != null ? resultSpec.offset : 0;
        int n3 = n2;
        if (n3 < 0 || n3 >= resultItemArray.length) {
            return EMPTY_RESULT_ITEMS;
        }
        int n4 = n = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        if (n == 0) {
            return EMPTY_RESULT_ITEMS;
        }
        int n5 = n3 + n;
        if (n5 >= resultItemArray.length || n < 0) {
            n5 = resultItemArray.length;
        }
        if (resultSpec.order != null) {
            Arrays.sort(resultItemArray, new ResultItemComparator(resultSpec.order));
        }
        ResultItem[] resultItemArray2 = resultItemArray;
        if (n3 > 0 || n5 < resultItemArray.length) {
            resultItemArray2 = Arrays.copyOfRange(resultItemArray, n3, n5);
        }
        return resultItemArray2;
    }

    private List<ResultItem> processConstraint(Constraint constraint, PropertySpec[] propertySpecArray) {
        List<ResultItem> list = null;
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            list = this.processObjectIdentityConstraint(objectIdentityConstraint, propertySpecArray);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            list = this.processCompositeConstraint(compositeConstraint, propertySpecArray);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            list = this.processRelationalConstraint(relationalConstraint, propertySpecArray);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            list = this.processPropertyConstraint(propertyConstraint, propertySpecArray);
        } else if (this.isSimpleConstraint(constraint)) {
            list = this.processSimpleConstraint(constraint, propertySpecArray);
        }
        if (list == null) {
            list = new ArrayList<ResultItem>();
        }
        return list;
    }

    private boolean isSimpleConstraint(Object object) {
        return object.getClass().getSimpleName().equals(Constraint.class.getSimpleName());
    }

    private List<ResultItem> processPropertyConstraint(PropertyConstraint propertyConstraint, PropertySpec[] propertySpecArray) {
        assert (propertyConstraint.comparator == Comparator.TEXTUALLY_MATCHES);
        String string = propertyConstraint.comparableValue.toString().toLowerCase();
        List<Object> list = this._objectStore.getObjectsByPropertyValue(propertyConstraint.targetType, propertyConstraint.propertyName, string);
        return this.createResultItemsForModelObject(list, propertySpecArray);
    }

    private List<ResultItem> processRelationalConstraint(RelationalConstraint relationalConstraint, PropertySpec[] propertySpecArray) {
        assert (relationalConstraint != null);
        assert (relationalConstraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        Object object = ((ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject).target;
        String string = this._objRefService.getResourceObjectType(object);
        if (string == null) {
            return arrayList;
        }
        RelationDescriptor relationDescriptor = new RelationDescriptor(string, relationalConstraint.relation, relationalConstraint.targetType);
        List<Object> list = this.getRelatedItems(object, relationDescriptor, relationalConstraint.hasInverseRelation);
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        return this.createResultItems(list, propertySpecArray);
    }

    private List<ResultItem> processCompositeConstraint(CompositeConstraint compositeConstraint, PropertySpec[] propertySpecArray) {
        List<ResultItem> list;
        block5: {
            block6: {
                list = new ArrayList<ResultItem>();
                if (compositeConstraint.conjoiner != Conjoiner.AND) break block6;
                for (Constraint constraint : compositeConstraint.nestedConstraints) {
                    List<ResultItem> list2 = this.processConstraint(constraint, propertySpecArray);
                    if (list2.size() == 0) {
                        return list2;
                    }
                    if (list.size() == 0) {
                        list = list2;
                        continue;
                    }
                    if ((list = this.intersect(list, list2)).size() != 0) {
                        continue;
                    }
                    break block5;
                }
                break block5;
            }
            if (compositeConstraint.conjoiner != Conjoiner.OR) break block5;
            for (Constraint constraint : compositeConstraint.nestedConstraints) {
                List<ResultItem> list3 = this.processConstraint(constraint, propertySpecArray);
                list.addAll(list3);
            }
        }
        return list;
    }

    private List<ResultItem> intersect(List<ResultItem> list, List<ResultItem> list2) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        block0: for (ResultItem resultItem : list) {
            String string = this._objRefService.getUid(resultItem.resourceObject);
            if (string == null) continue;
            for (ResultItem resultItem2 : list2) {
                String string2 = this._objRefService.getUid(resultItem2.resourceObject);
                if (!string.equals(string2)) continue;
                arrayList.add(resultItem);
                continue block0;
            }
        }
        return arrayList;
    }

    private List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecArray) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        if (HOST_TYPE.equals(constraint.targetType)) {
            return arrayList;
        }
        Map<String, ModelObject> map = null;
        if (CHASSIS_TYPE.equals(constraint.targetType)) {
            map = this._objectStore.getAllChassis();
        } else if (RACK_TYPE.equals(constraint.targetType)) {
            map = this._objectStore.getAllRacks();
        }
        for (ModelObject modelObject : map.values()) {
            URI uRI;
            ResultItem resultItem = this.createResultItem(modelObject, uRI = modelObject.getUri(this._uriResolver), propertySpecArray);
            if (resultItem == null) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> processObjectIdentityConstraint(ObjectIdentityConstraint objectIdentityConstraint, PropertySpec[] propertySpecArray) {
        ModelObject modelObject;
        ResultItem resultItem;
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        URI uRI = this.toURI(objectIdentityConstraint.target);
        if (uRI != null && (resultItem = this.createResultItem(modelObject = this._objectStore.getModelObject(uRI), uRI, propertySpecArray)) != null) {
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> createResultItems(List<Object> list, PropertySpec[] propertySpecArray) {
        assert (list != null && propertySpecArray != null);
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>(list.size());
        arrayList.addAll(this.createResultItemsForModelObject(list, propertySpecArray));
        arrayList.addAll(this.createResultItemsForNonModelObject(list, propertySpecArray));
        return arrayList;
    }

    private List<ResultItem> createResultItemsForModelObject(List<Object> list, PropertySpec[] propertySpecArray) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Object object : list) {
            URI uRI;
            ResultItem resultItem;
            if (!(object instanceof ModelObject) || (resultItem = this.createResultItem((ModelObject)object, uRI = ((ModelObject)object).getUri(this._uriResolver), propertySpecArray)) == null) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> createResultItemsForNonModelObject(List<Object> list, PropertySpec[] propertySpecArray) {
        ArrayList<ObjectIdentityConstraint> arrayList = new ArrayList<ObjectIdentityConstraint>();
        for (Object object : list) {
            if (object instanceof ModelObject) continue;
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = object;
            arrayList.add(objectIdentityConstraint);
        }
        if (arrayList.size() == 0) {
            return new ArrayList<ResultItem>();
        }
        return this.getResultItemsFromDataService(arrayList, propertySpecArray);
    }

    private List<ResultItem> getResultItemsFromDataService(List<ObjectIdentityConstraint> list, PropertySpec[] propertySpecArray) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = list.toArray(new Constraint[list.size()]);
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = compositeConstraint;
        querySpec.resourceSpec.propertySpecs = propertySpecArray;
        querySpec.resultSpec = new ResultSpec();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        if (response == null || response.resultSet.length == 0) {
            return new ArrayList<ResultItem>();
        }
        return Arrays.asList(response.resultSet[0].items);
    }

    private ResultItem createResultItem(ModelObject modelObject, URI uRI, PropertySpec[] propertySpecArray) {
        if (modelObject == null) {
            return null;
        }
        String[] stringArray = this.getRequestedPropertyNames(propertySpecArray);
        try {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = uRI;
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Object object = modelObject.getProperty(string);
                if (object == ModelObject.UNSUPPORTED_PROPERTY) continue;
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.resourceObject = uRI;
                propertyValue.propertyName = string;
                propertyValue.value = object;
                arrayList.add(propertyValue);
            }
            resultItem.properties = arrayList.toArray(new PropertyValue[0]);
            return resultItem;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error getting the ResultItem for " + uRI), (Throwable)exception);
            return null;
        }
    }

    private boolean validateQuerySpec(QuerySpec querySpec) {
        if (querySpec == null) {
            return false;
        }
        ResourceSpec resourceSpec = querySpec.resourceSpec;
        if (resourceSpec == null) {
            return false;
        }
        return this.validateConstraint(resourceSpec.constraint);
    }

    private boolean validateConstraint(Constraint constraint) {
        if (constraint == null) {
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            String string = this._objRefService.getResourceObjectType(((ObjectIdentityConstraint)constraint).target);
            return this.isSupportedType(string);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (this.validateConstraint(constraint2)) continue;
                return false;
            }
            return true;
        }
        if (constraint instanceof RelationalConstraint) {
            return this.isSupportedRelation((RelationalConstraint)constraint);
        }
        if (constraint instanceof PropertyConstraint) {
            return this.isSupportedType(constraint.targetType) && ((PropertyConstraint)constraint).comparator == Comparator.TEXTUALLY_MATCHES;
        }
        if (this.isSimpleConstraint(constraint)) {
            return this.isSupportedType(constraint.targetType);
        }
        _logger.error((Object)("querySpec constraint not supported: " + constraint.getClass().getName()));
        return false;
    }

    private boolean isSupportedType(String string) {
        return CHASSIS_TYPE.equals(string) || RACK_TYPE.equals(string) || HOST_TYPE.equals(string);
    }

    private boolean isSupportedRelation(RelationalConstraint relationalConstraint) {
        if (relationalConstraint.targetType == null || !(relationalConstraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            _logger.warn((Object)("RelationalConstraint not supported in relation: " + relationalConstraint.relation));
            return false;
        }
        Object object = ((ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject).target;
        String string = this._objRefService.getResourceObjectType(object);
        RelationDescriptor relationDescriptor = new RelationDescriptor(string, relationalConstraint.relation, relationalConstraint.targetType);
        if (!SUPPORTED_RELATIONS.contains(relationDescriptor)) {
            _logger.warn((Object)("Relation not supported: " + relationalConstraint.relation + ", sourceType: " + string + ", targetType: " + relationalConstraint.targetType));
            return false;
        }
        return this.isSupportedType(string);
    }

    private String[] getRequestedPropertyNames(PropertySpec[] propertySpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (propertySpecArray != null) {
            for (PropertySpec propertySpec : propertySpecArray) {
                for (String string : propertySpec.propertyNames) {
                    hashSet.add(string);
                }
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private URI toURI(Object object) {
        if (!(object instanceof URI)) {
            return null;
        }
        return (URI)object;
    }

    private ModelObject toModelObject(Object object) {
        if (!(object instanceof ModelObject)) {
            return null;
        }
        return (ModelObject)object;
    }

    private List<Object> getRelatedItems(Object object, RelationDescriptor relationDescriptor, boolean bl) {
        Object object2;
        boolean bl2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = null;
        boolean bl3 = bl2 = !bl;
        if (INVERSE_BY_FORWARD.containsKey(relationDescriptor)) {
            relationDescriptor = INVERSE_BY_FORWARD.get(relationDescriptor);
            bl2 = true;
        }
        if (bl2) {
            object2 = this._objRefService.getUid(object);
            object3 = this._objectStore.getRelationSource(relationDescriptor.name, (String)object2, relationDescriptor.targetType);
        } else if (object instanceof URI && (object2 = this._objectStore.getModelObject((URI)object)) != null) {
            object3 = ((ModelObject)object2).getProperty(relationDescriptor.name);
        }
        if (object3 == null || object3 == ModelObject.UNSUPPORTED_PROPERTY) {
            return arrayList;
        }
        if (object3 instanceof List) {
            arrayList.addAll((List)object3);
        } else if (object3.getClass().isArray()) {
            int n = Array.getLength(object3);
            for (int i = 0; i < n; ++i) {
                Object object4 = Array.get(object3, i);
                if (object4 == null) continue;
                arrayList.add(object4);
            }
        } else {
            object2 = this.toModelObject(object3);
            if (object2 != null) {
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    private void initializeHostRelations() {
        if (_hostRelationsInitialized) {
            return;
        }
        _hostRelationsInitialized = true;
        try {
            Object[] objectArray = this.getHosts(20);
            Map<String, ModelObject> map = this._objectStore.getAllChassis();
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                if (n < objectArray.length) {
                    this._objectStore.addHostToChassis(objectArray[n], string);
                    if (n + 1 < objectArray.length) {
                        this._objectStore.addHostToChassis(objectArray[n + 1], string);
                        n += 2;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in initializeHostRelations: ", (Throwable)exception);
        }
    }

    private Object[] getHosts(int n) {
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = new Constraint();
        querySpec.resourceSpec.constraint.targetType = HOST_TYPE;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"name"};
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        querySpec.resultSpec = new ResultSpec();
        querySpec.resultSpec.maxResultCount = new Integer(n);
        querySpec.resultSpec.order = new OrderingCriteria();
        querySpec.resultSpec.order.orderingProperties = new OrderingPropertySpec[0];
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        ResultItem[] resultItemArray = response.resultSet[0].items;
        if (resultItemArray == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[resultItemArray.length];
        for (int i = 0; i < resultItemArray.length; ++i) {
            objectArray[i] = resultItemArray[i].resourceObject;
        }
        return objectArray;
    }

    static {
        INVERSE_BY_FORWARD.put(new RelationDescriptor(HOST_TYPE, "chassis", CHASSIS_TYPE), new RelationDescriptor(HOST_TYPE, "host", CHASSIS_TYPE));
        EMPTY_RESULT_ITEMS = new ResultItem[0];
        _hostRelationsInitialized = false;
    }

    private static class RelationDescriptor {
        public final String sourceType;
        public final String name;
        public final String targetType;
        private volatile int _hashCode = 0;

        public RelationDescriptor(String string, String string2, String string3) {
            this.sourceType = string;
            this.name = string2;
            this.targetType = string3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelationDescriptor)) {
                return false;
            }
            RelationDescriptor relationDescriptor = (RelationDescriptor)object;
            return this.sourceType.equals(relationDescriptor.sourceType) && this.name.equals(relationDescriptor.name) && this.targetType.equals(relationDescriptor.targetType);
        }

        public int hashCode() {
            if (this._hashCode != 0) {
                return this._hashCode;
            }
            this._hashCode = 7;
            if (this.sourceType != null) {
                this._hashCode = 31 * this._hashCode + this.sourceType.hashCode();
            }
            if (this.name != null) {
                this._hashCode = 31 * this._hashCode + this.name.hashCode();
            }
            if (this.targetType != null) {
                this._hashCode = 31 * this._hashCode + this.targetType.hashCode();
            }
            return this._hashCode;
        }
    }
}

