/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import java.net.URI;
import java.net.URISyntaxException;

public class ModelObjectUriResolver
implements ResourceTypeResolver {
    private static final String SCHEME = "urn";
    private static final String NAMESPACE = "cr";
    private static final String UID_PREFIX = "urn:cr";
    private static final String TYPE_DELIMITER = ":";
    private static final String FRAGMENT_SEPARATOR = "/";

    public String getResourceType(URI uRI) {
        if (!this.isValid(uRI)) {
            this.throwExceptionForInvalidURI(uRI);
        }
        return this.parseUri(uRI, true);
    }

    public String getServerGuid(URI uRI) {
        String string = this.getId(uRI);
        int n = string.indexOf(FRAGMENT_SEPARATOR);
        if (n <= 0) {
            this.throwExceptionForInvalidURI(uRI);
        }
        return string.substring(0, n);
    }

    public String getId(URI uRI) {
        if (!this.isValid(uRI)) {
            this.throwExceptionForInvalidURI(uRI);
        }
        return this.parseUri(uRI, false);
    }

    public String getUid(URI uRI) {
        if (!this.isValid(uRI)) {
            this.throwExceptionForInvalidURI(uRI);
        }
        return uRI.toString();
    }

    public URI createUri(String string, String string2) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("type must be non-null.");
        }
        if (string2 == null || string2.length() < 1) {
            throw new IllegalArgumentException("id must be non-null.");
        }
        URI uRI = null;
        try {
            String string3 = "cr:" + string + TYPE_DELIMITER + string2;
            String string4 = null;
            uRI = new URI(SCHEME, string3, string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        return uRI;
    }

    public String createResourceId(String string, String string2) {
        String string3 = string + FRAGMENT_SEPARATOR + string2;
        return string3;
    }

    public boolean isValid(URI uRI) {
        return uRI != null && uRI.toString().startsWith(UID_PREFIX);
    }

    private String parseUri(URI uRI, boolean bl) {
        String string = uRI.getSchemeSpecificPart();
        int n = string.indexOf(TYPE_DELIMITER);
        int n2 = (string = string.substring(n + 1)).lastIndexOf(TYPE_DELIMITER);
        if (n2 == -1) {
            String string2 = "Invalid URI, missing type delimiter: " + this.toString(uRI);
            throw new IllegalArgumentException(string2);
        }
        String string3 = bl ? string.substring(0, n2) : string.substring(n2 + 1);
        return string3;
    }

    private void throwExceptionForInvalidURI(URI uRI) {
        throw new IllegalArgumentException("URI " + this.toString(uRI) + " is invalid for this resolver.");
    }

    private String toString(URI uRI) {
        if (uRI == null) {
            return null;
        }
        return uRI.toString();
    }
}

