/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb.model;

import com.vmware.samples.chassisb.model.ChassisInfo;
import com.vmware.samples.chassisb.model.ModelObject;
import com.vmware.samples.chassisb.model.Rack;
import com.vmware.vise.data.query.ObjectReferenceService;

public class Chassis
extends ModelObject {
    private final String _name;
    private final String _dimensions;
    private final String _serverType;
    private final Rack _rack;
    private Object[] _hosts = new Object[0];
    private Object _hostsLock = new Object();

    public Chassis(ChassisInfo chassisInfo, Rack rack, String string) {
        this.setId(string);
        this._name = chassisInfo.name;
        this._dimensions = chassisInfo.dimensions;
        this._serverType = chassisInfo.serverType;
        this._rack = rack;
    }

    public String getName() {
        return this._name;
    }

    public String getDimensions() {
        return this._dimensions;
    }

    public String getServerType() {
        return this._serverType;
    }

    public Rack getRack() {
        return this._rack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getHosts() {
        Object object = this._hostsLock;
        synchronized (object) {
            Object[] objectArray = new Object[this._hosts.length];
            System.arraycopy(this._hosts, 0, objectArray, 0, this._hosts.length);
            return objectArray;
        }
    }

    @Override
    public Object getProperty(String string) {
        if ("name".equals(string)) {
            return this.getName();
        }
        if ("serverType".equals(string)) {
            return this.getServerType();
        }
        if ("dimensions".equals(string)) {
            return this.getDimensions();
        }
        if ("rack".equals(string)) {
            return this.getRack();
        }
        if ("host".equals(string)) {
            return this.getHosts();
        }
        return UNSUPPORTED_PROPERTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHost(Object object, ObjectReferenceService objectReferenceService) {
        Object object2 = this._hostsLock;
        synchronized (object2) {
            if (this._hosts == null || this._hosts.length == 0) {
                return false;
            }
            String string = objectReferenceService.getUid(object);
            if (string == null) {
                return false;
            }
            for (Object object3 : this._hosts) {
                if (!string.equals(objectReferenceService.getUid(object3))) continue;
                this.removeHost(object3);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHost(Object object, ObjectReferenceService objectReferenceService) {
        Object object2 = this._hostsLock;
        synchronized (object2) {
            if (this._hosts == null || this._hosts.length == 0) {
                this._hosts = new Object[]{object};
                return true;
            }
            String string = objectReferenceService.getUid(object);
            if (string == null) {
                return false;
            }
            for (Object object3 : this._hosts) {
                if (!string.equals(objectReferenceService.getUid(object3))) continue;
                return false;
            }
            this.addHost(object);
            return true;
        }
    }

    private void addHost(Object object) {
        Object[] objectArray = new Object[this._hosts.length + 1];
        for (int i = 0; i < this._hosts.length; ++i) {
            objectArray[i] = this._hosts[i];
        }
        objectArray[this._hosts.length] = object;
        this._hosts = objectArray;
    }

    private void removeHost(Object object) {
        Object[] objectArray = new Object[this._hosts.length - 1];
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!bl && this._hosts[i] == object) {
                bl = true;
                continue;
            }
            objectArray[i] = this._hosts[i + (bl ? 1 : 0)];
        }
        this._hosts = objectArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Chassis)) {
            return false;
        }
        return this.getId().equals(((Chassis)object).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

