/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb.model;

import com.vmware.samples.chassisb.model.Chassis;
import com.vmware.samples.chassisb.model.ModelObject;
import java.util.ArrayList;
import java.util.List;

public class Rack
extends ModelObject {
    private volatile String _name;
    private volatile String _location;
    private final List<Chassis> _chassisList = new ArrayList<Chassis>();

    public Rack(String string, String string2, String string3) {
        this.setId(string3);
        this._name = string;
        this._location = string2;
    }

    public String getName() {
        return this._name;
    }

    public String getLocation() {
        return this._location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Chassis> getChassis() {
        List<Chassis> list = this._chassisList;
        synchronized (list) {
            if (this._chassisList.size() == 0) {
                return null;
            }
            return new ArrayList<Chassis>(this._chassisList);
        }
    }

    @Override
    public Object getProperty(String string) {
        if ("name".equals(string)) {
            return this.getName();
        }
        if ("location".equals(string)) {
            return this.getLocation();
        }
        if ("chassis".equals(string)) {
            return this.getChassis();
        }
        return UNSUPPORTED_PROPERTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChassis(Chassis chassis) {
        List<Chassis> list = this._chassisList;
        synchronized (list) {
            return this._chassisList.add(chassis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChassis(Chassis chassis) {
        List<Chassis> list = this._chassisList;
        synchronized (list) {
            return this._chassisList.remove(chassis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceChassis(Chassis chassis, Chassis chassis2) {
        List<Chassis> list = this._chassisList;
        synchronized (list) {
            int n = this._chassisList.indexOf(chassis);
            if (n >= 0) {
                this._chassisList.set(n, chassis2);
            }
        }
    }
}

