/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb.mvc;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionResult {
    static final String ACTIONUID = "actionUid";
    static final String ERROR_MESSAGE = "errorMessage";
    static final String RESULT = "result";
    static final String OPERATION_TYPE = "operationType";
    static final String OP_ADD = "add";
    static final String OP_CHANGE = "change";
    static final String OP_DELETE = "delete";
    static final String OP_RELATIONSHIP_CHANGE = "relationship_change";
    private static final Log _logger = LogFactory.getLog(ActionResult.class);
    private Map<String, Object> _resultMap = new HashMap<String, Object>();
    private String _resourceBundle;

    public ActionResult(String string, String string2) {
        this._resultMap.put(ACTIONUID, string);
        this._resourceBundle = string2;
    }

    public Map<String, Object> getJsonMap() {
        if (this._resultMap.get(RESULT) == null && this._resultMap.get(ERROR_MESSAGE) == null) {
            _logger.error((Object)("Missing result or error message in ActionResult for " + this._resultMap.get(ACTIONUID)));
        }
        return this._resultMap;
    }

    public void setResult(Object object, String string) {
        this._resultMap.put(RESULT, object);
        if (string != null && (object == null || object instanceof Boolean && !((Boolean)object).booleanValue())) {
            this.setErrorMessage(string);
        }
    }

    public void setObjectAddedResult(URI uRI, String string, String string2) {
        this._resultMap.put(RESULT, uRI);
        this._resultMap.put(OPERATION_TYPE, OP_ADD);
        this._resultMap.put("uriType", string);
        if (uRI == null && string2 != null) {
            this.setErrorMessage(string2);
        }
    }

    public void setObjectDeletedResult(boolean bl, String string) {
        this._resultMap.put(RESULT, bl);
        this._resultMap.put(OPERATION_TYPE, OP_DELETE);
        if (!bl && string != null) {
            this.setErrorMessage(string);
        }
    }

    public void setObjectChangedResult(boolean bl, String string) {
        this._resultMap.put(RESULT, bl);
        this._resultMap.put(OPERATION_TYPE, OP_CHANGE);
        if (!bl && string != null) {
            this.setErrorMessage(string);
        }
    }

    public void setErrorLocalizedMessage(String string) {
        this._resultMap.put(ERROR_MESSAGE, string);
    }

    public void setErrorMessage(String string) {
        this.setErrorMessage(string, null);
    }

    public void setErrorMessage(String string, String[] stringArray) {
        this._resultMap.put(ERROR_MESSAGE, new ActionMessage(this._resourceBundle, string, stringArray));
    }

    class ActionMessage {
        public String bundleName;
        public String key;
        public String[] params;

        ActionMessage() {
        }

        ActionMessage(String string, String string2, String[] stringArray) {
            this.bundleName = string;
            this.key = string2;
            this.params = stringArray;
        }
    }
}

