/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb.mvc;

import com.google.gson.Gson;
import com.vmware.samples.chassisb.ChassisService;
import com.vmware.samples.chassisb.model.ChassisInfo;
import com.vmware.samples.chassisb.mvc.ActionResult;
import com.vmware.samples.chassisb.mvc.ObjectIdUtil;
import com.vmware.samples.chassisb.mvc.QueryUtil;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actions.html"})
public class ActionsController {
    private static final Log _logger = LogFactory.getLog(ActionsController.class);
    private final String RESOURCE_BUNDLE = "com_vmware_samples_chassisb";
    private final ChassisService _chassisService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsController(ChassisService chassisService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._chassisService = chassisService;
        this._objectReferenceService = objectReferenceService;
        QueryUtil.setObjectReferenceService(objectReferenceService);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> invoke(@RequestParam(value="actionUid", required=true) String string, @RequestParam(value="targets", required=false) String string2, @RequestParam(value="json", required=false) String string3) throws Exception {
        Object object;
        Object object2;
        URI uRI = null;
        if (string2 != null) {
            object2 = string2.split(",");
            if (((String[])object2).length > 1) {
                _logger.warn((Object)("Action " + string + " called with " + ((String[])object2).length + " target objects, will use only the first one"));
            }
            if ((uRI = (URI)this._objectReferenceService.getReference((String)(object = ObjectIdUtil.decodeParameter(object2[0])))) == null) {
                _logger.error((Object)("Object not found with id: " + (String)object));
            }
        }
        object2 = null;
        if (string3 != null) {
            object = new Gson();
            object2 = (ChassisInfo)object.fromJson(string3, ChassisInfo.class);
        } else if (!string.equals("com.vmware.samples.chassisb.deleteChassis")) {
            _logger.error((Object)("Missing json data for " + string));
        }
        object = new ActionResult(string, "com_vmware_samples_chassisb");
        if (string.equals("com.vmware.samples.chassisb.editChassis")) {
            boolean bl = this._chassisService.updateChassis(uRI, (ChassisInfo)object2);
            ((ActionResult)object).setObjectChangedResult(bl, "editAction.notFound");
        } else if (string.equals("com.vmware.samples.chassisb.deleteChassis")) {
            boolean bl = this._chassisService.deleteChassis(uRI);
            ((ActionResult)object).setObjectDeletedResult(bl, "deleteAction.notFound");
        } else if (string.equals("com.vmware.samples.chassisb.createChassis")) {
            URI uRI2 = this._chassisService.createChassis((ChassisInfo)object2, null);
            if (uRI2 != null) {
                ((ActionResult)object).setObjectAddedResult(uRI2, "samples:ChassisB", null);
                ((ActionResult)object).setObjectChangedResult(true, null);
            } else {
                String[] stringArray = new String[]{object2.name};
                ((ActionResult)object).setErrorMessage("createAction.nameTaken", stringArray);
            }
        } else {
            String string4 = "Action not implemented yet! " + string;
            _logger.warn((Object)string4);
            ((ActionResult)object).setErrorLocalizedMessage(string4);
        }
        return ((ActionResult)object).getJsonMap();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception exception, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", exception.getMessage());
        if (exception.getCause() != null) {
            hashMap.put("cause", exception.getCause().getMessage());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        hashMap.put("stackTrace", stringWriter.toString());
        return hashMap;
    }
}

