/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisb.mvc;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class QueryUtil {
    private static ObjectReferenceService _objectReferenceService;

    public static void setObjectReferenceService(ObjectReferenceService objectReferenceService) {
        _objectReferenceService = objectReferenceService;
    }

    public static PropertyValue[] getProperties(DataService dataService, Object object, String[] stringArray) throws Exception {
        return QueryUtil.getProperties(dataService, new Object[]{object}, stringArray);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object[] objectArray, String[] stringArray) throws Exception {
        ResultItem[] resultItemArray;
        if (objectArray == null || objectArray.length == 0 || stringArray == null || stringArray.length == 0) {
            throw new Exception("Invalid parameters for getProperties");
        }
        Object object = objectArray[0];
        QuerySpec querySpec = QueryUtil.buildQuerySpec(objectArray, stringArray);
        querySpec.name = _objectReferenceService.getUid(object) + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return QueryUtil.toArray(arrayList, PropertyValue.class);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] objectArray = null;
        if (collection == null) {
            objectArray = (Object[])Array.newInstance(clazz, 0);
            return objectArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, collection.size());
        objectArray = collection.toArray(objectArray2);
        return objectArray;
    }

    public static PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String string, String string2, String string3) throws Exception {
        return QueryUtil.getPropertiesForRelatedObjects(dataService, object, string, string2, new String[]{string3});
    }

    public static PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object object, String string, String string2, String[] stringArray) throws Exception {
        if (object == null || stringArray == null || stringArray.length == 0) {
            throw new Exception("invalid parameters in getPropertiesForRelatedObjects");
        }
        if (string == null || string.length() == 0) {
            return QueryUtil.getProperties(dataService, object, stringArray);
        }
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(string, (Constraint)objectIdentityConstraint, true, string2);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)relationalConstraint, stringArray);
        querySpec.name = _objectReferenceService.getUid(object) + "." + string + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || resultItem.properties == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue == null) continue;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return QueryUtil.toArray(arrayList, PropertyValue.class);
    }

    public static ResultSet getData(DataService dataService, QuerySpec querySpec) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        ResultSet[] resultSetArray = response.resultSet;
        if (resultSetArray == null || resultSetArray.length == 0 || resultSetArray[0] == null) {
            throw new Exception("Empty result");
        }
        return resultSetArray[0];
    }

    public static QuerySpec buildQuerySpec(Object object, String[] stringArray) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        String string = _objectReferenceService.getResourceObjectType(object);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)objectIdentityConstraint, stringArray, hashSet);
        return querySpec;
    }

    public static QuerySpec buildQuerySpec(Object[] objectArray, String[] stringArray) {
        if (objectArray.length == 1) {
            return QueryUtil.buildQuerySpec(objectArray[0], stringArray);
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        Constraint[] constraintArray = new Constraint[objectArray.length];
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            constraintArray[i] = objectIdentityConstraint;
            string = _objectReferenceService.getResourceObjectType(objectIdentityConstraint.target);
            hashSet.add(string);
        }
        compositeConstraint.nestedConstraints = constraintArray;
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, stringArray, hashSet);
        return querySpec;
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray) {
        QuerySpec querySpec = QueryUtil.buildQuerySpec(constraint, stringArray, null);
        return querySpec;
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray, Set<String> set) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        if (set != null) {
            for (String string : set) {
                PropertySpec propertySpec = QueryUtil.createPropertySpec(stringArray, string);
                arrayList.add(propertySpec);
            }
        } else {
            PropertySpec propertySpec = QueryUtil.createPropertySpec(stringArray, null);
            arrayList.add(propertySpec);
        }
        resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[0]);
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    public static RelationalConstraint createRelationalConstraint(String string, Constraint constraint, Boolean bl, String string2) {
        RelationalConstraint relationalConstraint = new RelationalConstraint();
        relationalConstraint.relation = string;
        relationalConstraint.hasInverseRelation = bl;
        relationalConstraint.constraintOnRelatedObject = constraint;
        relationalConstraint.targetType = string2;
        return relationalConstraint;
    }

    public static ObjectIdentityConstraint createObjectIdentityConstraint(Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        objectIdentityConstraint.targetType = _objectReferenceService.getResourceObjectType(object);
        return objectIdentityConstraint;
    }

    private static PropertySpec createPropertySpec(String[] stringArray, String string) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = stringArray;
        return propertySpec;
    }
}

