/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibVersion {
    private static final Logger log = LoggerFactory.getLogger(LibVersion.class);
    private static final String DEFAULT_DEV_VERSION = "DEV";
    private static String fullVersion;

    public static final String getFullVersion() {
        if (fullVersion == null) {
            Properties versionProperties = new Properties();
            try {
                versionProperties.load(LibVersion.class.getResourceAsStream("/version.properties"));
                String apiVersionMajor = (String)versionProperties.get("api.version.major");
                String apiVersionMinor = (String)versionProperties.get("api.version.minor");
                String apiVersionRevision = (String)versionProperties.get("api.version.revision");
                if ("${api.version.major}".equals(apiVersionMajor)) {
                    log.warn("API version cannot be loaded from version.properties because the actual values have not been set. That indicates a dev environment which is cleaned/rebuilt through the IDE and not through Maven. The version string will be reported as 'DEV' (single component instead of the three-component version 2.5.89173). If you however need full version, e.g. for testing purposes, you should rebuild through Maven.");
                    fullVersion = DEFAULT_DEV_VERSION;
                } else {
                    fullVersion = apiVersionMajor + "." + apiVersionMinor + "." + apiVersionRevision;
                }
            }
            catch (IOException e) {
                log.warn("API version cannot be loaded from version.properties because the file is missing or cannot be read. The version string will be reported as 'DEV'. Check the underlying exception. ", (Throwable)e);
                fullVersion = DEFAULT_DEV_VERSION;
            }
        }
        return fullVersion;
    }
}

