/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.serialization.rdf;

import com.vmware.ph.client.api.commondataformat.serialization.rdf.CompactTurtleWriter;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.TurtleCdfSequenceSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

public class CdfSequenceSerializerFactory {
    public static final RDFFormat DEFAULT_RDF_FORMAT = RDFFormat.TURTLE;

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializer(Writer writer) throws IOException {
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(new CompactTurtleWriter(writer));
    }

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializer(Writer writer, RDFFormat format) throws IOException {
        RDFWriter rdfWriter = Rio.createWriter(format, writer);
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(rdfWriter);
    }

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializer(OutputStream stream) throws IOException {
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(new CompactTurtleWriter(stream));
    }

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializer(OutputStream stream, RDFFormat format) throws IOException {
        RDFWriter writer = Rio.createWriter(format, stream);
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(writer);
    }

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializerNoNamespaces(OutputStream stream) throws IOException {
        TurtleWriterNoNamespaces writer = new TurtleWriterNoNamespaces(stream);
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(writer);
    }

    public static RdfCdfSequenceSerializer createRdfCdfSequenceSerializerNoNamespaces(Writer writer) throws IOException {
        TurtleWriterNoNamespaces rdfWriter = new TurtleWriterNoNamespaces(writer);
        return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(rdfWriter);
    }

    private static RdfCdfSequenceSerializer createRdfCdfSequenceSerializer(RDFHandler handler) throws IOException {
        try {
            RdfCdfSequenceSerializer result = handler instanceof CompactTurtleWriter ? new TurtleCdfSequenceSerializer((CompactTurtleWriter)handler) : new RdfCdfSequenceSerializer(handler);
            return result;
        }
        catch (RDFHandlerException e) {
            throw RdfCdfSequenceSerializer.toIOException(e);
        }
    }

    static class TurtleWriterNoNamespaces
    extends CompactTurtleWriter {
        public TurtleWriterNoNamespaces(OutputStream out) {
            super(out);
        }

        public TurtleWriterNoNamespaces(Writer writer) {
            super(writer);
        }

        @Override
        protected void writeNamespace(String prefix, String name) throws IOException {
        }
    }
}

