/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.serialization.rdf;

import com.vmware.ph.client.api.commondataformat.serialization.rdf.CompactTurtleWriter;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandlerException;

public class TurtleCdfSequenceSerializer
extends RdfCdfSequenceSerializer {
    private final CompactTurtleWriter compactWriter;

    TurtleCdfSequenceSerializer(CompactTurtleWriter handler) throws RDFHandlerException {
        super(handler);
        this.compactWriter = handler;
    }

    @Override
    public void write(FreeFormData str) throws IOException {
        URI resourceUri = this.idAsUri(str.getId());
        try {
            this.compactWriter.handleStatement(new StatementImpl(resourceUri, RDF.TYPE, this.typeAsUri(str.getType())));
            ArrayList<Value> rdfTable = new ArrayList<Value>();
            for (AnyPrimitive[] inputRow : str.getData()) {
                ArrayList<Value> rdfRow = new ArrayList<Value>();
                for (AnyPrimitive element : inputRow) {
                    rdfRow.add(this.primitiveAsValue(element));
                }
                rdfTable.add(CompactTurtleWriter.createListValue(rdfRow));
            }
            this.compactWriter.handleStatement(new StatementImpl(resourceUri, this.predAsUri("data"), CompactTurtleWriter.createListValue(rdfTable)));
        }
        catch (RDFHandlerException e) {
            throw TurtleCdfSequenceSerializer.toIOException(e);
        }
    }
}

