/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.impl.aggregation;

import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.impl.aggregation.Buffer;
import com.vmware.ph.client.api.impl.aggregation.DataProcessor;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.upload.exception.UploadFailedException;
import com.vmware.ph.upload.service.UploadService;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Aggregator {
    private static final Logger log = LoggerFactory.getLogger(Aggregator.class);
    private final Buffer buffer;
    private final DataProcessor processor;
    private final UploadRunner uploadRunner;
    private final TimeBasedUploadScheduler uploadScheduler;
    private final SizeBasedUploadCriteria sizeBasedUploadCriteria;

    public Aggregator(String collectorId, String instanceId, long uploadPeriodMillis, Buffer buffer, DataProcessor processor, UploadService uploadService, CeipConfigProvider ceipConfigProvider) {
        this(uploadPeriodMillis, buffer, processor, new UploadRunner(collectorId, instanceId, buffer, uploadService, ceipConfigProvider));
    }

    Aggregator(long uploadPeriodMillis, Buffer buffer, DataProcessor processor, UploadRunner uploadRunner) {
        this(buffer, processor, uploadRunner, new TimeBasedUploadScheduler(uploadPeriodMillis, uploadRunner));
    }

    Aggregator(Buffer buffer, DataProcessor processor, UploadRunner uploadRunner, TimeBasedUploadScheduler uploadScheduler) {
        Aggregator.validateBuffer(buffer);
        Aggregator.validateDataProcessor(processor);
        this.buffer = buffer;
        this.processor = processor;
        this.uploadRunner = uploadRunner;
        this.sizeBasedUploadCriteria = new SizeBasedUploadCriteria(buffer);
        this.uploadScheduler = uploadScheduler;
        this.uploadScheduler.schedule();
    }

    public void add(CdfAble cdf) {
        byte[] b = this.processData(cdf);
        this.writeInBuffer(b);
        this.tryToUpload();
    }

    private byte[] processData(CdfAble cdf) {
        log.trace("start processing CdfAble {}", (Object)cdf);
        byte[] result = this.processor.process(cdf);
        log.trace("end processing CdfAble", (Object)cdf);
        return result;
    }

    private void tryToUpload() {
        this.uploadRunner.tryToUpload(UploadOrigin.SIZE, this.sizeBasedUploadCriteria);
    }

    private void writeInBuffer(byte[] b) {
        try {
            this.buffer.writeData(b, 0, b.length);
            log.trace(b.length + "bytes written in the buffer.");
        }
        catch (IOException e) {
            log.error("There was an error when writing to the buffer. The data is not written in the buffer and will not be recovered. If there is a recovery approach it will be described in theunderlying IOException message. If this exception persists, please contact the PhoneHome team.", (Throwable)e);
        }
    }

    static void validateUploadPeriodMillis(long uploadPeriodMillis) {
        if (uploadPeriodMillis <= 0L) {
            throw new IllegalArgumentException("The uploadPeriodMillis is the period between two regular size-based uploads. Thus it must be positive, but it is = " + uploadPeriodMillis + " Provide a positive value.");
        }
    }

    static void validateIdNotBlank(String idName, String idValue) {
        if (StringUtils.isBlank(idValue)) {
            throw new IllegalArgumentException("The " + idName + " must not be blank, but it is = " + idValue + ". As a result uploads cannot be executed. Provide not blank value");
        }
    }

    static void validateBuffer(Buffer buffer) {
        Aggregator.validateNotNull(buffer, "The buffer is responsible for the buffering of the data. Thus it must not be null, but it is and aggregation will not work. Provide a non-null value.");
    }

    static void validateDataProcessor(DataProcessor processor) {
        Aggregator.validateNotNull(processor, "DataProcessor is responsible for the serialization of the aggregated data. Thus is must not be null, but it is and the aggregation will nto work. Provide a non-null value.");
    }

    static void validateUploadService(UploadService uploadService) {
        Aggregator.validateNotNull(uploadService, "The uploadService is responsible for uploading the aggregated data. Thus it must not be null, but it is and uploads will not work. Provide a non-null value.");
    }

    static void validateCeipConfigProvider(CeipConfigProvider ceipConfigProvider) {
        Aggregator.validateNotNull(ceipConfigProvider, "CeipConfigProvider is responsible for validating whether upload is allowed. Thus it must not be null, but it is and uploads will not work. Provide a non-null value.");
    }

    static void validateNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static enum UploadOrigin {
        TIME,
        SIZE;

    }

    static class TimeBasedUploadCriteria
    implements UploadCriteria {
        private final long uploadPeriodMillis;
        private final UploadRunner uploadRunner;

        public TimeBasedUploadCriteria(long uploadPeriodMillis, UploadRunner uploadRunner) {
            Aggregator.validateUploadPeriodMillis(uploadPeriodMillis);
            this.uploadPeriodMillis = uploadPeriodMillis;
            this.uploadRunner = uploadRunner;
        }

        @Override
        public boolean isMet() {
            long now = System.currentTimeMillis();
            return now > this.uploadRunner.getLastUploadMillis() + this.uploadPeriodMillis;
        }
    }

    static class SizeBasedUploadCriteria
    implements UploadCriteria {
        private final Buffer buffer;

        public SizeBasedUploadCriteria(Buffer buffer) {
            Aggregator.validateBuffer(buffer);
            this.buffer = buffer;
        }

        @Override
        public boolean isMet() {
            return this.buffer.isReadyToConsume();
        }
    }

    static interface UploadCriteria {
        public boolean isMet();
    }

    static class TimeBasedUploadTimerTask
    extends TimerTask {
        private static final Logger log = LoggerFactory.getLogger(TimeBasedUploadTimerTask.class);
        private final long uploadPeriodMillis;
        private final UploadRunner uploadRunner;

        public TimeBasedUploadTimerTask(long uploadPeriodMillis, UploadRunner uploadRunner) {
            Aggregator.validateUploadPeriodMillis(uploadPeriodMillis);
            this.uploadPeriodMillis = uploadPeriodMillis;
            this.uploadRunner = uploadRunner;
        }

        @Override
        public void run() {
            log.trace("Time-based upload task awakes and tries to upload.");
            this.uploadRunner.tryToUpload(UploadOrigin.TIME, new TimeBasedUploadCriteria(this.uploadPeriodMillis, this.uploadRunner));
            log.trace("Time-based upload task finished upload attemt.");
        }
    }

    static class TimeBasedUploadScheduler {
        private final long delay;
        private final long wakeUpPeriodMillis;
        private final Timer timer;
        private final TimerTask timerTask;

        public TimeBasedUploadScheduler(long uploadPeriodMillis, UploadRunner uploadRunner) {
            this(uploadPeriodMillis, uploadRunner, 5000L, uploadPeriodMillis / 5L);
        }

        TimeBasedUploadScheduler(long uploadPeriodMillis, UploadRunner uploadRunner, long delay, long wakeUpPeriodMillis) {
            Aggregator.validateUploadPeriodMillis(uploadPeriodMillis);
            this.timer = new Timer("aggregation-timer", true);
            this.timerTask = new TimeBasedUploadTimerTask(uploadPeriodMillis, uploadRunner);
            this.delay = delay;
            this.wakeUpPeriodMillis = wakeUpPeriodMillis;
        }

        public void schedule() {
            this.timer.scheduleAtFixedRate(this.timerTask, this.delay, this.wakeUpPeriodMillis);
            log.debug("scheduled a TimeBasedUploadTimerTask with delay={} and wakeUpPeriodMillis={}", (Object)this.delay, (Object)this.wakeUpPeriodMillis);
        }
    }

    @ThreadSafe
    static class UploadRunner {
        private static final Logger log = LoggerFactory.getLogger(UploadRunner.class);
        private final String collectorId;
        private final String instanceId;
        private final Buffer buffer;
        private final UploadService uploadService;
        private final CeipConfigProvider ceipConfigProvider;
        private final AtomicBoolean uploading;
        private volatile long lastUploadMillis;

        public UploadRunner(String collectorId, String instanceId, Buffer buffer, UploadService uploadService, CeipConfigProvider ceipConfigProvider) {
            Aggregator.validateIdNotBlank("collectorId", collectorId);
            Aggregator.validateBuffer(buffer);
            Aggregator.validateUploadService(uploadService);
            Aggregator.validateCeipConfigProvider(ceipConfigProvider);
            this.collectorId = collectorId;
            this.instanceId = instanceId;
            this.buffer = buffer;
            this.uploadService = uploadService;
            this.ceipConfigProvider = ceipConfigProvider;
            this.uploading = new AtomicBoolean(false);
            this.lastUploadMillis = System.currentTimeMillis();
        }

        public long getLastUploadMillis() {
            return this.lastUploadMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tryToUpload(UploadOrigin origin, UploadCriteria criteria) {
            if (criteria.isMet()) {
                log.debug("{} criteria is met. If not already running, upload will be executed.", (Object)origin);
                if (this.uploading.compareAndSet(false, true)) {
                    try {
                        if (criteria.isMet()) {
                            this.doUpload(origin);
                        }
                        log.debug("The Criteria, based on which the upload attempt will be executed or not, is no longer met. This can happen if TIME and SIZE upload attempts were racing for the upload and this thread didn't win the race condition. This is expected behavior and no further action is required - the upload was started by another thread.");
                    }
                    finally {
                        this.uploading.set(false);
                    }
                } else {
                    log.debug("Upload is already running.");
                }
            }
        }

        private String getCeipDisabledMessage() {
            String msg = "Buffered data will not be uploaded - Customer Experience Improvement Program (CEIP) is not enabled. As a result the data will not be uploaded. The isCeipEnabled call was executed against " + CeipConfigProvider.class.getSimpleName() + "=" + this.ceipConfigProvider + " You can enable data upload by agreeing to CEIP consent (or by configuring another " + CeipConfigProvider.class.getSimpleName() + ".";
            return msg;
        }

        private void doUpload(UploadOrigin origin) {
            if (!this.ceipConfigProvider.isCeipEnabled()) {
                String msg = this.getCeipDisabledMessage();
                log.debug(msg);
                System.out.println(msg);
                return;
            }
            log.debug("Upload initiated for origin = " + (Object)((Object)origin));
            try {
                Buffer.BufferedData data = this.buffer.getBufferedData();
                if (data != null) {
                    log.debug("Starting upload of buffered data.");
                    Future<?> upload = this.uploadService.upload(this.collectorId, this.instanceId, UUID.randomUUID().toString().replace("-", ""), data.getInputStream(), data.getLength());
                    log.debug("Upload started. Waiting for upload to finish.");
                    upload.get();
                    log.debug("The upload of buffered data is finished.");
                    this.buffer.releaseData(true);
                    this.lastUploadMillis = System.currentTimeMillis();
                } else {
                    log.debug("Not data aggregated in the buffer.");
                }
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
            catch (ExecutionException e) {
                this.handleExecutionException(e);
            }
        }

        private void handleRuntimeException(RuntimeException e) {
            log.error("There was an error during the upload and the aggregated data is not uploaded.There will be other attemts to upload the same data.If however this data is not uploaded for such a period that a lot of new data is aggregated, then the old data will be discarded.If this error persists, it may mean that the PhoneHome upload server is not working,or that there is no outbound connectivity to the PhoneHome upload server.Please contact the PhoneHome team for assistance.", (Throwable)e);
            this.buffer.releaseData(false);
        }

        private void handleInterruptedException(InterruptedException e) {
            log.error("The upload thread was interrupted while uploading aggregated data.As a result the data is not uploaded.This usually happens when the PhClient is closed, or the upload thread was manually stopped.In such case, this exception is expected and no recovery is required.If this is not the case, please contact the PhoneHome team.", (Throwable)e);
            this.buffer.releaseData(false);
        }

        private void handleExecutionException(ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UploadFailedException) {
                log.error("There was an error during the upload and the aggregated data is not uploaded.There will be other attemts to upload the same data.If however this data is not uploaded for such a period that a lot of new data is aggregated, then the old data will be discarded.This may mean that the PhoneHome upload server is not working, that there is no outbound connectivity to the PhoneHome upload server, or that there is a bug in the upload functionality.Please contact the PhoneHome team for assistance.", cause);
            } else {
                log.error("There was a bug during the upload and the aggregated data is not uploaded.There will be other attemts to upload the same data.If however this data is not uploaded for such a period that a lot of new data is aggregated, then the old data will be discarded. Please contact the PhoneHome team for assistance.", cause);
            }
            this.buffer.releaseData(false);
        }
    }
}

